/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.core.SonarCore;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.ClientFlux;
import sonar.flux.network.ClientNetworkCache;

public class PacketDisconnectedTiles
implements IMessage {
    public List<ClientFlux> client_flux;

    public PacketDisconnectedTiles() {
    }

    public PacketDisconnectedTiles(List<ClientFlux> client_flux) {
        this.client_flux = client_flux;
    }

    public void fromBytes(ByteBuf buf) {
        this.client_flux = new ArrayList<ClientFlux>();
        PacketDisconnectedTiles.clientFluxFromBuf(buf, this.client_flux);
    }

    public void toBytes(ByteBuf buf) {
        PacketDisconnectedTiles.clientFluxToBuf(buf, this.client_flux);
    }

    public static void clientFluxFromBuf(ByteBuf buf, List<ClientFlux> tiles) {
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
            tiles.add(new ClientFlux(tag));
        }
    }

    public static void clientFluxToBuf(ByteBuf buf, List<ClientFlux> tiles) {
        buf.writeInt(tiles.size());
        for (int i = 0; i < tiles.size(); ++i) {
            ClientFlux flux = tiles.get(i);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)flux.writeData(new NBTTagCompound(), NBTHelper.SyncType.SAVE));
        }
    }

    public static class Handler
    implements IMessageHandler<PacketDisconnectedTiles, IMessage> {
        public IMessage onMessage(PacketDisconnectedTiles message, MessageContext ctx) {
            SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                ClientNetworkCache.instance().disconnected_tiles = message.client_flux;
            });
            return null;
        }
    }
}

