/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.connection.NetworkSettings;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketColourCache;

public class PacketColourRequest
implements IMessage {
    public List<Integer> requests;

    public PacketColourRequest() {
    }

    public PacketColourRequest(List<Integer> requests) {
        this.requests = requests;
    }

    public void fromBytes(ByteBuf buf) {
        this.requests = new ArrayList<Integer>();
        int size = buf.readInt();
        for (int i = 0; i < size; ++i) {
            this.requests.add(buf.readInt());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.requests.size());
        this.requests.forEach(arg_0 -> ((ByteBuf)buf).writeInt(arg_0));
    }

    public static class Handler
    implements IMessageHandler<PacketColourRequest, IMessage> {
        public IMessage onMessage(PacketColourRequest message, MessageContext ctx) {
            Iterator<Integer> iterator;
            HashMap<Integer, Tuple<Integer, String>> cache = new HashMap<Integer, Tuple<Integer, String>>();
            if (!message.requests.isEmpty() && (iterator = message.requests.iterator()).hasNext()) {
                int id = iterator.next();
                IFluxNetwork network = FluxNetworkCache.instance().getNetwork(id);
                cache.put(id, new Tuple((Object)network.getSetting(NetworkSettings.NETWORK_COLOUR).getRGB(), (Object)(network.isFakeNetwork() ? "NONE" : network.getSetting(NetworkSettings.NETWORK_NAME))));
                return new PacketColourCache(cache);
            }
            return null;
        }
    }
}

