/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.api;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.flux.api.ClientTransferHandler;
import sonar.flux.api.EnumActivationType;
import sonar.flux.api.EnumPriorityType;
import sonar.flux.api.energy.internal.ITransferHandler;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.api.network.PlayerAccess;
import sonar.flux.api.tiles.IFlux;
import sonar.flux.connection.FluxNetworkInvalid;

public class ClientFlux
implements IFlux,
INBTSyncable {
    public BlockCoords coords;
    public IFlux.ConnectionType connection_type;
    public boolean isChunkLoaded = true;
    public int network_id;
    public int priority;
    public int folder_id;
    public long limit;
    public String customName;
    public ItemStack stack;
    public boolean disableLimit;
    public EnumActivationType activation_type;
    public EnumPriorityType priority_type;
    public ClientTransferHandler handler;

    public ClientFlux(IFlux flux) {
        this.coords = flux.getCoords();
        this.connection_type = flux.getConnectionType();
        this.network_id = flux.getNetworkID();
        this.priority = flux.getCurrentPriority();
        this.folder_id = flux.getFolderID();
        this.limit = flux.getTransferLimit();
        this.customName = flux.getCustomName();
        this.handler = ClientTransferHandler.getInstanceFromHandler(flux, flux.getTransferHandler());
        this.stack = flux.getDisplayStack();
        this.disableLimit = flux.getDisableLimit();
        this.activation_type = flux.getActivationType();
        this.priority_type = flux.getPriorityType();
    }

    public ClientFlux(BlockCoords coords, IFlux.ConnectionType type, int network_id, int priority, int folder_id, long limit, String customName, boolean disableLimit, EnumActivationType activation_type, EnumPriorityType priority_type, ClientTransferHandler handler, ItemStack stack) {
        this.coords = coords;
        this.connection_type = type;
        this.network_id = network_id;
        this.priority = priority;
        this.folder_id = folder_id;
        this.limit = limit;
        this.customName = customName;
        this.handler = handler;
        this.stack = stack;
        this.disableLimit = disableLimit;
        this.activation_type = activation_type;
        this.priority_type = priority_type;
    }

    public ClientFlux(NBTTagCompound tag) {
        this.readData(tag, NBTHelper.SyncType.SAVE);
    }

    public void setChunkLoaded(boolean isChunkLoaded) {
        this.isChunkLoaded = isChunkLoaded;
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        this.coords = BlockCoords.readFromNBT((NBTTagCompound)nbt);
        this.connection_type = IFlux.ConnectionType.values()[nbt.func_74762_e("type")];
        this.network_id = nbt.func_74762_e("n_id");
        this.priority = nbt.func_74762_e("priority");
        this.folder_id = nbt.func_74762_e("folder_id");
        this.limit = nbt.func_74763_f("limit");
        this.customName = nbt.func_74779_i("name");
        this.handler = new ClientTransferHandler(this);
        this.handler.readData(nbt.func_74775_l("handler"), type);
        this.isChunkLoaded = nbt.func_74767_n("isChunkLoaded");
        this.disableLimit = nbt.func_74767_n("dLimit");
        this.activation_type = EnumActivationType.values()[nbt.func_74762_e("a_type")];
        this.priority_type = EnumPriorityType.values()[nbt.func_74762_e("p_type")];
        this.stack = new ItemStack(nbt);
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        BlockCoords.writeToNBT((NBTTagCompound)nbt, (BlockCoords)this.coords);
        nbt.func_74768_a("type", this.connection_type.ordinal());
        nbt.func_74768_a("n_id", this.network_id);
        nbt.func_74768_a("priority", this.priority);
        nbt.func_74768_a("folder_id", this.folder_id);
        nbt.func_74772_a("limit", this.limit);
        nbt.func_74778_a("name", this.customName);
        nbt.func_74782_a("handler", (NBTBase)this.handler.writeData(new NBTTagCompound(), type));
        nbt.func_74757_a("isChunkLoaded", this.isChunkLoaded);
        nbt.func_74757_a("dLimit", this.disableLimit);
        nbt.func_74768_a("a_type", this.activation_type.ordinal());
        nbt.func_74768_a("p_type", this.priority_type.ordinal());
        this.stack.func_77955_b(nbt);
        return nbt;
    }

    public void addToGuiList(List list, boolean origin, boolean transfers) {
        if (origin) {
            list.add(this);
        }
        if (transfers && this.isChunkLoaded()) {
            list.addAll(this.handler.getTransfers());
        }
    }

    public int getDimensionID() {
        return this.coords.getDimension();
    }

    @Override
    public World getDimension() {
        return this.coords.getWorld();
    }

    @Override
    public BlockCoords getCoords() {
        return this.coords;
    }

    @Override
    public IFluxNetwork getNetwork() {
        return FluxNetworkInvalid.INVALID;
    }

    @Override
    public IFlux.ConnectionType getConnectionType() {
        return this.connection_type;
    }

    @Override
    public long getTransferLimit() {
        return this.limit;
    }

    @Override
    public long getCurrentLimit() {
        return this.limit;
    }

    @Override
    public boolean getDisableLimit() {
        return this.disableLimit;
    }

    @Override
    public EnumActivationType getActivationType() {
        return this.activation_type;
    }

    @Override
    public EnumPriorityType getPriorityType() {
        return this.priority_type;
    }

    @Override
    public int getCurrentPriority() {
        return this.priority;
    }

    @Override
    public int getFolderID() {
        return this.folder_id;
    }

    @Override
    public String getCustomName() {
        return this.customName;
    }

    @Override
    public UUID getConnectionOwner() {
        return null;
    }

    @Override
    public int getNetworkID() {
        return this.network_id;
    }

    @Override
    public void connect(IFluxNetwork network) {
    }

    @Override
    public void disconnect(IFluxNetwork network) {
    }

    @Override
    public PlayerAccess canAccess(EntityPlayer player) {
        return null;
    }

    @Override
    public ITransferHandler getTransferHandler() {
        return this.handler;
    }

    @Override
    public boolean isChunkLoaded() {
        return this.isChunkLoaded;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.stack;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientFlux) {
            return ((ClientFlux)obj).getCoords().equals((Object)this.getCoords());
        }
        return false;
    }
}

