/*
 * Decompiled with CFR 0.152.
 */
package ts2k16.blacklist;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;
import ts2k16.core.TS2K16;

public class BlockEntry {
    private final ResourceLocation idName;
    private final String oreDict;
    private final int subType;

    public BlockEntry(ResourceLocation idName, int subType) {
        this.idName = idName;
        this.subType = subType;
        this.oreDict = null;
    }

    public BlockEntry(String oreDict) {
        this.oreDict = oreDict;
        this.idName = null;
        this.subType = -1;
    }

    public boolean checkMatch(IBlockState state) {
        if (state == null) {
            return false;
        }
        return this.checkMatch(state.func_177230_c(), state.func_177230_c().func_176201_c(state));
    }

    public boolean checkMatch(Block block, int metadata) {
        if (block == null || block == Blocks.field_150350_a) {
            return false;
        }
        if (this.idName == null) {
            return this.checkOre(block, metadata);
        }
        ResourceLocation r = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)block);
        return r.equals((Object)this.idName) && (this.subType < 0 || this.subType == Short.MAX_VALUE || this.subType == metadata);
    }

    private boolean checkOre(Block block, int metadata) {
        if (this.oreDict == null) {
            return false;
        }
        if (this.oreDict.equals("*")) {
            return true;
        }
        Item itemBlock = Item.func_150898_a((Block)block);
        if (itemBlock == Items.field_190931_a) {
            return false;
        }
        for (int id : OreDictionary.getOreIDs((ItemStack)new ItemStack(block))) {
            if (!OreDictionary.getOreName((int)id).equals(this.oreDict)) continue;
            return true;
        }
        return false;
    }

    public static BlockEntry readFromString(String s) {
        int meta;
        if (s == null || s.length() <= 0) {
            return null;
        }
        String[] split = s.split(":");
        if (split.length <= 0 || split.length > 3) {
            return null;
        }
        if (split.length == 1) {
            return new BlockEntry(split[0]);
        }
        if (split.length == 2) {
            return new BlockEntry(new ResourceLocation(split[0], split[1]), -1);
        }
        try {
            meta = Integer.parseInt(split[2]);
        }
        catch (Exception e) {
            TS2K16.logger.log(Level.ERROR, "Unable to read metadata value for Block Entry \"" + s + "\":", (Throwable)e);
            return null;
        }
        return new BlockEntry(new ResourceLocation(split[0], split[1]), meta);
    }
}

