/*
 * Decompiled with CFR 0.152.
 */
package com.setycz.chickens.item;

import com.setycz.chickens.entity.EntityChickensChicken;
import com.setycz.chickens.handler.IColorSource;
import com.setycz.chickens.registry.ChickensRegistry;
import com.setycz.chickens.registry.ChickensRegistryItem;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;

public class ItemSpawnEgg
extends Item
implements IColorSource {
    public ItemSpawnEgg() {
        this.func_77627_a(true);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            for (ChickensRegistryItem chicken : ChickensRegistry.getItems()) {
                ItemStack itemstack = new ItemStack((Item)this, 1);
                ItemSpawnEgg.applyEntityIdToItemStack(itemstack, chicken.getRegistryName());
                subItems.add((Object)itemstack);
            }
        }
    }

    public String func_77653_i(ItemStack stack) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return "null";
        }
        return I18n.func_74838_a((String)("entity." + chickenDescription.getEntityName() + ".name"));
    }

    @Override
    public int getColorFromItemStack(ItemStack stack, int renderPass) {
        ChickensRegistryItem chickenDescription = ChickensRegistry.getByRegistryName(ItemSpawnEgg.getTypeFromStack(stack));
        if (chickenDescription == null) {
            return 0;
        }
        return renderPass == 0 ? chickenDescription.getBgColor() : chickenDescription.getFgColor();
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            ItemStack stack = playerIn.func_184586_b(hand);
            BlockPos correlatedPos = this.correctPosition(pos, facing);
            this.activate(stack, worldIn, correlatedPos, stack.func_77960_j());
            if (!playerIn.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private BlockPos correctPosition(BlockPos pos, EnumFacing side) {
        int[] offsetsXForSide = new int[]{0, 0, 0, 0, -1, 1};
        int[] offsetsYForSide = new int[]{-1, 1, 0, 0, 0, 0};
        int[] offsetsZForSide = new int[]{0, 0, -1, 1, 0, 0};
        int posX = pos.func_177958_n() + offsetsXForSide[side.ordinal()];
        int posY = pos.func_177956_o() + offsetsYForSide[side.ordinal()];
        int posZ = pos.func_177952_p() + offsetsZForSide[side.ordinal()];
        return new BlockPos(posX, posY, posZ);
    }

    private void activate(ItemStack stack, World worldIn, BlockPos pos, int metadata) {
        ResourceLocation entityName = new ResourceLocation("chickens", "chickenschicken");
        EntityChickensChicken entity = (EntityChickensChicken)EntityList.func_188429_b((ResourceLocation)entityName, (World)worldIn);
        if (entity == null) {
            return;
        }
        entity.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
        entity.func_180482_a(worldIn.func_175649_E(pos), null);
        entity.setChickenType(ItemSpawnEgg.getTypeFromStack(stack));
        NBTTagCompound stackNBT = stack.func_77978_p();
        if (stackNBT != null) {
            NBTTagCompound entityNBT = entity.func_189511_e(new NBTTagCompound());
            entityNBT.func_179237_a(stackNBT);
            entity.func_70037_a(entityNBT);
        }
        worldIn.func_72838_d((Entity)entity);
    }

    public static void applyEntityIdToItemStack(ItemStack stack, ResourceLocation entityId) {
        NBTTagCompound nbttagcompound = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        NBTTagCompound nbttagcompound1 = new NBTTagCompound();
        nbttagcompound1.func_74778_a("id", entityId.toString());
        nbttagcompound.func_74782_a("ChickenType", (NBTBase)nbttagcompound1);
        stack.func_77982_d(nbttagcompound);
    }

    @Nullable
    public static String getTypeFromStack(ItemStack stack) {
        NBTTagCompound nbttagcompound = stack.func_77978_p();
        if (nbttagcompound != null && nbttagcompound.func_150297_b("ChickenType", 10)) {
            new NBTTagCompound();
            NBTTagCompound chickentag = nbttagcompound.func_74775_l("ChickenType");
            return chickentag.func_74779_i("id");
        }
        return null;
    }
}

