/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.item.stencil;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.Deque;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import openblocks.client.renderer.TextureUploader;
import openblocks.client.renderer.item.stencil.StencilableBitmap;
import openblocks.common.IStencilPattern;
import openmods.Log;

public class StencilTextureManager {
    public static final StencilTextureManager INSTANCE = new StencilTextureManager();
    private final Map<ResourceLocation, TexturePool> pools = Maps.newHashMap();

    private StencilTextureManager() {
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre evt) {
        for (TexturePool pool : this.pools.values()) {
            pool.allocate(evt.getMap());
        }
    }

    public StencilTextureManager register(ResourceLocation background, int size) {
        TexturePool newPool = new TexturePool(size, background);
        TexturePool prev = this.pools.put(background, newPool);
        Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Duplicate value for entry '%s'", (Object)background);
        return this;
    }

    public ResourceLocation getStencilTextureLocation(ResourceLocation background, IStencilPattern pattern) {
        TexturePool texturePool = this.pools.get(background);
        Preconditions.checkState((texturePool != null ? 1 : 0) != 0, (Object)"Pool for '%' not registered");
        return texturePool.get(pattern);
    }

    public ResourceLocation getEmptyStencilTextureLocation(ResourceLocation background) {
        TexturePool texturePool = this.pools.get(background);
        Preconditions.checkState((texturePool != null ? 1 : 0) != 0, (Object)"Pool for '%' not registered");
        return texturePool.getEmpty();
    }

    private static class TexturePool {
        private final int size;
        private final ResourceLocation background;
        private TextureAtlasSprite backgroundSprite;
        private final Deque<PoolTexture> freeLocations = Queues.newArrayDeque();
        private final Map<IStencilPattern, PoolTexture> usedLocations = Maps.newHashMap();
        private StencilableBitmap bitmap;

        public TexturePool(int size, ResourceLocation background) {
            this.size = size;
            this.background = background;
        }

        public void allocate(TextureMap textureMap) {
            int mipmapLevels = textureMap.getMipmapLevels();
            this.freeLocations.clear();
            for (int i = 0; i < this.size; ++i) {
                ResourceLocation newLocation = new ResourceLocation(this.background.func_110624_b(), this.background.func_110623_a() + "-" + i);
                PoolTexture pooledSprite = new PoolTexture(newLocation, mipmapLevels);
                this.freeLocations.push(pooledSprite);
                textureMap.setTextureEntry((TextureAtlasSprite)pooledSprite);
            }
            this.usedLocations.clear();
        }

        public ResourceLocation get(IStencilPattern pattern) {
            PoolTexture result = this.usedLocations.get(pattern);
            if (result != null) {
                return result.selfLocation;
            }
            result = this.freeLocations.poll();
            if (result == null) {
                Log.warn((String)"No more textures in pool for %s, returning blank one", (Object[])new Object[]{this.background});
                return this.background;
            }
            result.loadPattern(pattern);
            this.usedLocations.put(pattern, result);
            return result.selfLocation;
        }

        public ResourceLocation getEmpty() {
            return this.background;
        }

        private class PoolTexture
        extends TextureAtlasSprite {
            private final ResourceLocation selfLocation;
            private int mipmapLevels;
            private boolean queuedForUpload;
            private IStencilPattern pattern;

            private PoolTexture(ResourceLocation selfLocation, int mipmapLevels) {
                super(selfLocation.toString());
                this.selfLocation = selfLocation;
                this.mipmapLevels = mipmapLevels;
            }

            public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
                return true;
            }

            private void copyTextureDataFromPrimer() {
                this.func_130103_l();
                this.field_110976_a.add(TexturePool.this.backgroundSprite.func_147965_a(0));
            }

            public Collection<ResourceLocation> getDependencies() {
                return ImmutableSet.of((Object)TexturePool.this.background);
            }

            public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
                if (TexturePool.this.backgroundSprite == null) {
                    TexturePool.this.backgroundSprite = textureGetter.apply(TexturePool.this.background);
                }
                this.field_130223_c = TexturePool.this.backgroundSprite.func_94211_a();
                this.field_130224_d = TexturePool.this.backgroundSprite.func_94216_b();
                this.copyTextureDataFromPrimer();
                return false;
            }

            public void func_147963_d(int level) {
                this.mipmapLevels = level;
                this.copyTextureDataFromPrimer();
            }

            public void loadPattern(IStencilPattern pattern) {
                if (TexturePool.this.bitmap == null) {
                    TexturePool.this.bitmap = new StencilableBitmap(TexturePool.this.backgroundSprite.func_147965_a(0)[0], this.field_130223_c);
                }
                if (!this.queuedForUpload) {
                    this.queuedForUpload = true;
                    this.pattern = pattern;
                    TextureUploader.INSTANCE.scheduleTextureUpload(this::upload);
                }
            }

            private void upload() {
                this.queuedForUpload = false;
                this.func_130103_l();
                Object mipmaps = new int[this.mipmapLevels + 1][];
                mipmaps[0] = TexturePool.this.bitmap.apply(this.pattern);
                mipmaps = TextureUtil.func_147949_a((int)this.mipmapLevels, (int)this.field_130223_c, (int[][])mipmaps);
                this.field_110976_a.add(mipmaps);
                TextureUtil.func_147955_a((int[][])mipmaps, (int)this.field_130223_c, (int)this.field_130224_d, (int)this.field_110975_c, (int)this.field_110974_d, (boolean)false, (boolean)false);
            }
        }
    }
}

