/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.mutations;

import com.rwtema.careerbees.helpers.FieldAccessor;
import com.rwtema.careerbees.mutations.CareerBeesMutationBooleanCondition;
import forestry.api.climate.IClimateProvider;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IGenome;
import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ExplosionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class MutationRecentExplosion
extends CareerBeesMutationBooleanCondition {
    private static final WeakHashMap<World, TObjectIntHashMap<BlockPos>> map = new WeakHashMap();
    private static final FieldAccessor<Boolean, Explosion> damagesTerrain = new FieldAccessor(Explosion.class, "damagesTerrain", "field_82755_b");

    public MutationRecentExplosion() {
        super("Must have been a nearby explosion in the last 10 seconds");
    }

    @SubscribeEvent
    public static void explosion(@Nonnull ExplosionEvent event) {
        Explosion explosion = event.getExplosion();
        if (!damagesTerrain.get(explosion).booleanValue()) {
            return;
        }
        BlockPos pos = new BlockPos(explosion.getPosition());
        map.computeIfAbsent(event.getWorld(), w -> new TObjectIntHashMap()).put((Object)pos, 250);
    }

    @SubscribeEvent
    public static void worldTick(@Nonnull TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        TObjectIntHashMap<BlockPos> map = MutationRecentExplosion.map.get(event.world);
        if (map != null) {
            TObjectIntIterator iterator = map.iterator();
            while (iterator.hasNext()) {
                iterator.advance();
                int i = iterator.value();
                if (i <= 0) {
                    iterator.remove();
                    continue;
                }
                iterator.setValue(i - 1);
            }
            if (map.isEmpty()) {
                MutationRecentExplosion.map.remove(event.world);
            }
        }
    }

    public static int getManhattenDist(@Nonnull Vec3i a, @Nonnull Vec3i b) {
        return Math.abs(a.func_177958_n() - b.func_177958_n()) + Math.abs(a.func_177956_o() - b.func_177956_o()) + Math.abs(a.func_177952_p() - b.func_177952_p());
    }

    @Override
    protected boolean isAcceptable(World world, @Nonnull BlockPos pos, IAllele allele0, IAllele allele1, IGenome genome0, IGenome genome1, IClimateProvider climate) {
        TObjectIntHashMap<BlockPos> positions = map.get(world);
        if (positions == null) {
            return false;
        }
        for (BlockPos blockPos : positions.keySet()) {
            if (MutationRecentExplosion.getManhattenDist((Vec3i)blockPos, (Vec3i)pos) >= 30) continue;
            return true;
        }
        return false;
    }

    static {
        MinecraftForge.EVENT_BUS.register(MutationRecentExplosion.class);
    }
}

