/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.effects;

import com.google.common.collect.HashMultimap;
import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.effects.EffectItemModification;
import com.rwtema.careerbees.lang.Lang;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.DoubleUnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EffectAttributeBoost
extends EffectItemModification {
    protected static final UUID ATTACK_DAMAGE_MODIFIER = UUID.fromString("CB3F55D3-645C-4F38-A497-9C13A33DB5CF");
    protected static final UUID ATTACK_SPEED_MODIFIER = UUID.fromString("FA233E1C-4180-4865-B01B-BCCE9785ACA3");
    private static final String attributeModifiersCustom = "AttributeModifiersCustom";
    static final HashSet<UUID> instances = new HashSet();
    @Nonnull
    final UUID uuid;
    final HashMap<EntityEquipmentSlot, UUID> map = new HashMap();

    public EffectAttributeBoost(String name, float baseTicksBetweenProcessing, @Nonnull UUID uuid) {
        this(name, false, false, baseTicksBetweenProcessing, 1.0f, uuid);
    }

    public EffectAttributeBoost(String name, boolean isDominant, boolean isCombinable, float baseTicksBetweenProcessing, float chanceOfProcessing, @Nonnull UUID uuid) {
        super(name, isDominant, isCombinable, baseTicksBetweenProcessing, chanceOfProcessing);
        this.uuid = uuid;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            UUID uuid1 = slot.ordinal() == 0 ? uuid : new UUID(uuid.getLeastSignificantBits(), uuid.getMostSignificantBits() + (long)slot.ordinal());
            this.map.put(slot, uuid1);
        }
        this.map.put(null, new UUID(uuid.getLeastSignificantBits(), uuid.getMostSignificantBits() - 1L));
        instances.addAll(this.map.values());
    }

    @SubscribeEvent
    public static void onSpawn(@Nonnull PlayerEvent.PlayerRespawnEvent event) {
        EffectAttributeBoost.recheckAttributes((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public static void onSpawn(@Nonnull PlayerEvent.PlayerLoggedInEvent event) {
        EffectAttributeBoost.recheckAttributes((EntityLivingBase)event.player);
    }

    @SubscribeEvent
    public static void onInvChange(@Nonnull LivingEquipmentChangeEvent event) {
        EffectAttributeBoost.recheckAttributes(event.getEntityLiving());
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void addTooltips(@Nonnull ItemTooltipEvent event) {
        ItemStack itemStack = event.getItemStack();
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null || !tagCompound.func_150297_b(attributeModifiersCustom, 9) || tagCompound.func_150295_c(attributeModifiersCustom, 10).func_74745_c() <= 0) {
            return;
        }
        List list = event.getToolTip();
        list.add(TextFormatting.GOLD + Lang.translate("Career Bee Modifiers:"));
        for (EntityEquipmentSlot entityequipmentslot : EntityEquipmentSlot.values()) {
            HashMultimap<String, AttributeModifier> multimap = EffectAttributeBoost.getModifiers(itemStack, entityequipmentslot);
            if (multimap == null || multimap.isEmpty()) continue;
            list.add(" " + TextFormatting.GOLD + I18n.func_74838_a((String)("item.modifiers." + entityequipmentslot.func_188450_d())));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                double d0 = attributemodifier.func_111164_d();
                double d1 = attributemodifier.func_111169_c() != 1 && attributemodifier.func_111169_c() != 2 ? d0 : d0 * 100.0;
                if (d0 > 0.0) {
                    list.add(TextFormatting.BLUE + "  " + I18n.func_74837_a((String)("attribute.modifier.plus." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add(TextFormatting.RED + "  " + I18n.func_74837_a((String)("attribute.modifier.take." + attributemodifier.func_111169_c()), (Object[])new Object[]{ItemStack.field_111284_a.format(d1 *= -1.0), I18n.func_74838_a((String)("attribute.name." + (String)entry.getKey()))}));
            }
        }
    }

    public static void recheckAttributes(@Nonnull EntityLivingBase entityLivingBase) {
        for (IAttributeInstance instance : entityLivingBase.func_110140_aT().func_111146_a()) {
            for (UUID uuid1 : instances) {
                instance.func_188479_b(uuid1);
            }
        }
        for (EntityEquipmentSlot entityEquipmentSlot : EntityEquipmentSlot.values()) {
            ItemStack itemStackFromSlot = entityLivingBase.func_184582_a(entityEquipmentSlot);
            HashMultimap<String, AttributeModifier> modifiers = EffectAttributeBoost.getModifiers(itemStackFromSlot, entityEquipmentSlot);
            if (modifiers == null) continue;
            entityLivingBase.func_110140_aT().func_111147_b(modifiers);
        }
    }

    private static HashMultimap<String, AttributeModifier> getModifiers(@Nonnull ItemStack stack, @Nullable EntityEquipmentSlot equipmentSlot) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_150297_b(attributeModifiersCustom, 9)) {
            HashMultimap multimap = HashMultimap.create();
            NBTTagList nbttaglist = tagCompound.func_150295_c(attributeModifiersCustom, 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
                AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nbttagcompound);
                if (attributemodifier == null || nbttagcompound.func_150297_b("Slot", 8) && equipmentSlot != null && !nbttagcompound.func_74779_i("Slot").equals(equipmentSlot.func_188450_d()) || attributemodifier.func_111167_a().getLeastSignificantBits() == 0L || attributemodifier.func_111167_a().getMostSignificantBits() == 0L) continue;
                multimap.put((Object)nbttagcompound.func_74779_i("AttributeName"), (Object)attributemodifier);
            }
            return multimap;
        }
        return null;
    }

    @Nullable
    public ItemStack boostStat(@Nonnull ItemStack stack, @Nonnull IAttribute attribute, @Nullable EntityEquipmentSlot slot, int operation, @Nonnull DoubleUnaryOperator unaryOperator, double initialMissingValue) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        UUID uuid = this.map.get(slot);
        if (tagCompound == null) {
            tagCompound = new NBTTagCompound();
            stack.func_77982_d(tagCompound);
        }
        if (!tagCompound.func_150297_b(attributeModifiersCustom, 9)) {
            NBTTagList nbttaglist = new NBTTagList();
            AttributeModifier modifier = new AttributeModifier(uuid, "Bee Modification", unaryOperator.applyAsDouble(initialMissingValue), operation);
            nbttaglist.func_74742_a((NBTBase)this.getAttributeModifierNBT(attribute, slot, modifier));
            tagCompound.func_74782_a(attributeModifiersCustom, (NBTBase)nbttaglist);
            return stack;
        }
        NBTTagList nbttaglist = tagCompound.func_150295_c(attributeModifiersCustom, 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            AttributeModifier attributemodifier = SharedMonsterAttributes.func_111259_a((NBTTagCompound)nbttagcompound);
            if (attributemodifier == null || !uuid.equals(attributemodifier.func_111167_a())) continue;
            double amountIn = unaryOperator.applyAsDouble(attributemodifier.func_111164_d());
            if (amountIn == attributemodifier.func_111164_d() && operation == attributemodifier.func_111169_c()) {
                return null;
            }
            AttributeModifier modifier = new AttributeModifier(uuid, "Bee Modification", amountIn, operation);
            NBTTagCompound nbt = this.getAttributeModifierNBT(attribute, slot, modifier);
            nbttaglist.func_150304_a(i, (NBTBase)nbt);
            return stack;
        }
        AttributeModifier modifier = new AttributeModifier(uuid, "Bee Modification", unaryOperator.applyAsDouble(initialMissingValue), operation);
        nbttaglist.func_74742_a((NBTBase)this.getAttributeModifierNBT(attribute, slot, modifier));
        return stack;
    }

    @Nonnull
    private NBTTagCompound getAttributeModifierNBT(@Nonnull IAttribute attribute, @Nullable EntityEquipmentSlot slot, @Nonnull AttributeModifier modifier) {
        NBTTagCompound nbt = SharedMonsterAttributes.func_111262_a((AttributeModifier)modifier);
        nbt.func_74778_a("AttributeName", attribute.func_111108_a());
        if (slot != null) {
            nbt.func_74778_a("Slot", slot.func_188450_d());
        }
        return nbt;
    }

    protected static DoubleUnaryOperator getDoubleUnaryOperator(double max, double mult, double granularity) {
        return t -> t > max ? max : Math.ceil(t * granularity + mult * (max - t)) / granularity;
    }

    public static void test(@Nonnull DoubleUnaryOperator unaryOperator, double initialMissingValue) {
        double prev;
        StringBuilder builder = new StringBuilder("\n");
        double t = initialMissingValue;
        int n = 0;
        do {
            ++n;
            builder.append(t).append(' ');
        } while ((prev = t) != (t = unaryOperator.applyAsDouble(t)));
        builder.append('\n').append(n);
        BeeMod.logger.info(builder.toString());
    }

    static {
        MinecraftForge.EVENT_BUS.register(EffectAttributeBoost.class);
    }
}

