/*
 * Decompiled with CFR 0.152.
 */
package sonar.core.sync;

import cofh.redstoneflux.api.IEnergyStorage;
import net.darkhax.tesla.api.ITeslaConsumer;
import net.darkhax.tesla.api.ITeslaHolder;
import net.darkhax.tesla.api.ITeslaProducer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fml.common.Optional;
import sonar.core.api.utils.ActionType;
import sonar.core.sync.ISyncHandler;
import sonar.core.sync.ISyncValue;
import sonar.core.sync.IValueWatcher;
import sonar.core.sync.SyncHandlerPrimitive;

@Optional.InterfaceList(value={@Optional.Interface(iface="net.darkhax.tesla.api.ITeslaConsumer", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaHolder", modid="tesla"), @Optional.Interface(iface="net.darkhax.tesla.api.ITeslaProducer", modid="tesla"), @Optional.Interface(iface="cofh.redstoneflux.api.IEnergyStorage", modid="redstoneflux")})
public class SyncValueEnergyStorage
extends EnergyStorage
implements ISyncValue<Integer>,
ITeslaConsumer,
ITeslaProducer,
ITeslaHolder,
IEnergyStorage {
    public final IValueWatcher watcher;
    public static final ISyncHandler<Integer> handler = new EnergyStorageSyncHandler();
    public boolean isDirty;

    public SyncValueEnergyStorage(IValueWatcher watcher) {
        this(watcher, 10000);
    }

    public SyncValueEnergyStorage(IValueWatcher watcher, int capacity) {
        this(watcher, capacity, capacity, capacity, 0);
    }

    public SyncValueEnergyStorage(IValueWatcher watcher, int capacity, int maxTransfer) {
        this(watcher, capacity, maxTransfer, maxTransfer, 0);
    }

    public SyncValueEnergyStorage(IValueWatcher watcher, int capacity, int maxReceive, int maxExtract) {
        this(watcher, capacity, maxReceive, maxExtract, 0);
    }

    public SyncValueEnergyStorage(IValueWatcher watcher, int capacity, int maxReceive, int maxExtract, int energy) {
        super(capacity, maxReceive, maxExtract, energy);
        this.watcher = watcher;
        this.watcher.addSyncValue(this);
    }

    public SyncValueEnergyStorage setCapacity(int capacity) {
        this.capacity = capacity;
        return this;
    }

    public SyncValueEnergyStorage setMaxTransfer(int maxTransfer) {
        this.setMaxReceive(maxTransfer);
        this.setMaxExtract(maxTransfer);
        return this;
    }

    public SyncValueEnergyStorage setMaxReceive(int maxReceive) {
        this.maxReceive = maxReceive;
        return this;
    }

    public SyncValueEnergyStorage setMaxExtract(int maxExtract) {
        this.maxExtract = maxExtract;
        return this;
    }

    public void setEnergyStored(int energy) {
        this.setValue(this.checkCapacity(energy));
    }

    public int getMaxReceive() {
        return this.maxReceive;
    }

    public int getMaxExtract() {
        return this.maxExtract;
    }

    public int checkCapacity(int energy) {
        if (energy > this.capacity) {
            return this.capacity;
        }
        if (energy < 0) {
            return 0;
        }
        return energy;
    }

    public final int receiveEnergy(int maxReceive, boolean simulate) {
        int prev_energy = this.energy;
        int received = super.receiveEnergy(maxReceive, simulate);
        if (prev_energy != this.energy) {
            this.setDirty(true);
            this.watcher.onSyncValueChanged(this);
        }
        return received;
    }

    public final int extractEnergy(int maxExtract, boolean simulate) {
        int prev_energy = this.energy;
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (prev_energy != this.energy) {
            this.setDirty(true);
            this.watcher.onSyncValueChanged(this);
        }
        return extracted;
    }

    public final long removeEnergy(long maxTransferRF, ActionType actionType) {
        return this.extractEnergy((int)Math.min(maxTransferRF, Integer.MAX_VALUE), actionType.shouldSimulate());
    }

    public final long addEnergy(long maxTransferRF, ActionType actionType) {
        return this.receiveEnergy((int)Math.min(maxTransferRF, Integer.MAX_VALUE), actionType.shouldSimulate());
    }

    public long givePower(long power, boolean simulated) {
        return this.receiveEnergy((int)Math.min(Integer.MAX_VALUE, power), simulated);
    }

    public long getStoredPower() {
        return this.getEnergyStored();
    }

    public long getCapacity() {
        return this.getMaxEnergyStored();
    }

    public long takePower(long power, boolean simulated) {
        return this.extractEnergy((int)Math.min(Integer.MAX_VALUE, power), simulated);
    }

    @Override
    public String getTagName() {
        return "energy";
    }

    @Override
    public ISyncHandler<Integer> getSyncHandler() {
        return handler;
    }

    @Override
    public Integer getValue() {
        return this.energy;
    }

    @Override
    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public boolean setValueInternal(Integer set) {
        if (this.energy != set) {
            this.energy = set;
            this.watcher.onSyncValueChanged(this);
            return true;
        }
        return false;
    }

    @Override
    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public static class EnergyStorageSyncHandler
    extends SyncHandlerPrimitive.SyncHandlerInteger {
        private static final String OLD_TAG = "energyStorage";

        @Override
        public Integer load(NBTTagCompound tag, String key) {
            if (tag.func_74764_b(OLD_TAG)) {
                NBTTagCompound nbt = tag.func_74775_l(OLD_TAG);
                return nbt.func_74762_e("Energy");
            }
            return tag.func_74762_e(key);
        }
    }
}

