/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.tile.ore;

import com.buuz135.industrial.api.recipe.ore.OreFluidEntryRaw;
import com.buuz135.industrial.proxy.FluidsRegistry;
import com.buuz135.industrial.tile.CustomElectricMachine;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;
import net.ndrei.teslacorelib.gui.BasicRenderedGuiPiece;
import net.ndrei.teslacorelib.gui.BasicTeslaGuiContainer;
import net.ndrei.teslacorelib.gui.IGuiContainerPiece;
import net.ndrei.teslacorelib.gui.LockedInventoryTogglePiece;
import net.ndrei.teslacorelib.inventory.BoundingRectangle;
import net.ndrei.teslacorelib.inventory.FluidTankType;
import net.ndrei.teslacorelib.inventory.LockableItemHandler;
import net.ndrei.teslacorelib.tileentities.SidedTileEntity;
import org.jetbrains.annotations.NotNull;

public class OreWasherTile
extends CustomElectricMachine {
    private IFluidTank input;
    private IFluidTank output;
    private LockableItemHandler items;
    private OreFluidEntryRaw recipe;

    public OreWasherTile() {
        super(OreWasherTile.class.getName().hashCode());
    }

    @Override
    protected void initializeInventories() {
        super.initializeInventories();
        this.input = this.addSimpleFluidTank(8000, "input", EnumDyeColor.BLUE, 60, 25, FluidTankType.INPUT, stack -> true, stack -> false);
        this.output = this.addSimpleFluidTank(8000, "output", EnumDyeColor.ORANGE, 136, 25, FluidTankType.OUTPUT, stack -> false, stack -> true);
        this.items = (LockableItemHandler)this.addSimpleInventory(1, "input", EnumDyeColor.GREEN, "input", new BoundingRectangle(98, 26, 18, 18), (stack, integer) -> true, (stack, integer) -> false, true, null);
    }

    @Override
    public void protectedUpdate() {
        super.protectedUpdate();
        if (this.field_145850_b.func_82737_E() % 5L == 0L) {
            if (this.recipe != null && !this.recipe.matches(this.getFirstStack(), this.input.getFluid())) {
                this.recipe = null;
            }
            if (this.recipe == null) {
                for (OreFluidEntryRaw oreRawEntry : OreFluidEntryRaw.ORE_RAW_ENTRIES) {
                    if (!oreRawEntry.matches(this.getFirstStack(), this.input.getFluid())) continue;
                    this.recipe = oreRawEntry;
                    break;
                }
            }
        }
    }

    protected float performWork() {
        if (this.recipe != null && this.input.drain(this.recipe.getInput().amount, false) != null && this.input.drain((int)this.recipe.getInput().amount, (boolean)false).amount == this.recipe.getInput().amount && this.output.fill(this.recipe.getOutput(), false) == this.recipe.getOutput().amount) {
            this.getFirstStack().func_190918_g(1);
            this.input.drain(this.recipe.getInput().amount, true);
            this.output.fill(this.recipe.getOutput().copy(), true);
            return 1.0f;
        }
        return 0.0f;
    }

    @Override
    @NotNull
    public List<IGuiContainerPiece> getGuiContainerPieces(BasicTeslaGuiContainer<?> container) {
        List<IGuiContainerPiece> pieces = super.getGuiContainerPieces(container);
        pieces.add((IGuiContainerPiece)new LockedInventoryTogglePiece(118, 28, (SidedTileEntity)this, EnumDyeColor.GREEN));
        pieces.add((IGuiContainerPiece)new BasicRenderedGuiPiece(98, 58, 18, 18, new ResourceLocation("industrialforegoing", "textures/gui/machines.png"), 1, 168){

            public void drawBackgroundLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, float partialTicks, int mouseX, int mouseY) {
                super.drawBackgroundLayer(container, guiX, guiY, partialTicks, mouseX, mouseY);
                if (OreWasherTile.this.recipe != null) {
                    Color color;
                    GlStateManager.func_179094_E();
                    TextureAtlasSprite sprite = container.field_146297_k.func_147117_R().getTextureExtry(FluidsRegistry.MEAT.getFlowing().toString());
                    if (sprite != null) {
                        container.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        GlStateManager.func_179147_l();
                        color = new Color(FluidsRegistry.MEAT.getColor());
                        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)color.getAlpha() / 255.0f));
                        container.func_175175_a(guiX + this.getLeft() + 1, guiY + this.getTop() + 1, sprite, 16, 16);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        GlStateManager.func_179084_k();
                    }
                    RenderHelper.func_74520_c();
                    container.field_146297_k.func_175599_af().func_175042_a(OreWasherTile.this.getFirstStack(), guiX + this.getLeft() + 1, guiY + this.getTop() + 1);
                    sprite = container.field_146297_k.func_147117_R().getTextureExtry(FluidsRegistry.ORE_FLUID_RAW.getFlowing().toString());
                    if (sprite != null) {
                        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)120.0f);
                        container.field_146297_k.func_110434_K().func_110577_a(TextureMap.field_110575_b);
                        color = new Color(FluidsRegistry.ORE_FLUID_RAW.getColor(OreWasherTile.this.recipe.getOutput()));
                        GlStateManager.func_179131_c((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)((float)OreWasherTile.this.getWorkEnergyStored() / (float)OreWasherTile.this.getWorkEnergyCapacity()));
                        container.func_175175_a(guiX + this.getLeft() + 1, guiY + this.getTop() + 1, sprite, 16, 16);
                        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    }
                    GlStateManager.func_179141_d();
                    GlStateManager.func_179121_F();
                }
            }

            public void drawForegroundTopLayer(@NotNull BasicTeslaGuiContainer<?> container, int guiX, int guiY, int mouseX, int mouseY) {
                super.drawForegroundTopLayer(container, guiX, guiY, mouseX, mouseY);
            }
        });
        return pieces;
    }

    public ItemStack getFirstStack() {
        return this.items.getStackInSlot(0);
    }

    protected boolean shouldAddFluidItemsInventory() {
        return false;
    }
}

