/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.tweaks.ai;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.util.math.MathHelper;
import vazkii.quark.tweaks.feature.PatTheDogs;

public class EntityAIWantLove
extends EntityAIBase {
    private static final String PET_TIME = "quark:PetTime";
    private final EntityTameable creature;
    private EntityLivingBase leapTarget;
    public final float leapUpMotion;

    public static void setPetTime(EntityTameable entity) {
        entity.getEntityData().func_74772_a(PET_TIME, entity.field_70170_p.func_82737_E());
    }

    public static boolean needsPets(EntityTameable entity) {
        if (PatTheDogs.dogsWantLove <= 0 || !entity.func_70909_n()) {
            return false;
        }
        long lastPetAt = entity.getEntityData().func_74763_f(PET_TIME);
        long sinceLastPet = entity.field_70170_p.func_82737_E() - lastPetAt;
        return sinceLastPet > (long)PatTheDogs.dogsWantLove;
    }

    public EntityAIWantLove(EntityTameable creature, float leapMotion) {
        this.creature = creature;
        this.leapUpMotion = leapMotion;
        this.func_75248_a(5);
    }

    public boolean func_75250_a() {
        if (!EntityAIWantLove.needsPets(this.creature)) {
            return false;
        }
        this.leapTarget = this.creature.func_70902_q();
        if (this.leapTarget == null) {
            return false;
        }
        double distanceToTarget = this.creature.func_70068_e((Entity)this.leapTarget);
        return 4.0 <= distanceToTarget && distanceToTarget <= 16.0 && this.creature.field_70122_E && this.creature.func_70681_au().nextInt(5) == 0;
    }

    public boolean func_75253_b() {
        if (!EntityAIWantLove.needsPets(this.creature)) {
            return false;
        }
        return !this.creature.field_70122_E;
    }

    public void func_75249_e() {
        double dX = this.leapTarget.field_70165_t - this.creature.field_70165_t;
        double dZ = this.leapTarget.field_70161_v - this.creature.field_70161_v;
        float leapMagnitude = MathHelper.func_76133_a((double)(dX * dX + dZ * dZ));
        if ((double)leapMagnitude >= 1.0E-4) {
            this.creature.field_70159_w += dX / (double)leapMagnitude * 0.4 + this.creature.field_70159_w * 0.2;
            this.creature.field_70179_y += dZ / (double)leapMagnitude * 0.4 + this.creature.field_70179_y * 0.2;
        }
        this.creature.field_70181_x = this.leapUpMotion;
    }
}

