/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ToStringer {
    private final List<Pair<String, Object>> list = new ArrayList<Pair<String, Object>>();
    private final String name;

    public ToStringer(@NonNull Object object) {
        Sanity.nullCheck(object, "Object");
        this.name = object.getClass().getSimpleName();
    }

    public @NonNull ToStringer add(@NonNull String name, @Nullable Object object) {
        Sanity.nullCheck(name, "Name");
        this.list.add(new Pair<String, Object>(name, object));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, boolean b) {
        this.add(name, String.valueOf(b));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, byte b) {
        this.add(name, String.valueOf(b));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, char c) {
        this.add(name, String.valueOf(c));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, double d) {
        this.add(name, String.valueOf(d));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, float f) {
        this.add(name, String.valueOf(f));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, int i) {
        this.add(name, String.valueOf(i));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, long l) {
        this.add(name, String.valueOf(l));
        return this;
    }

    public @NonNull ToStringer add(@NonNull String name, short s) {
        this.add(name, String.valueOf(s));
        return this;
    }

    public @NonNull String toString() {
        StringBuilder builder = new StringBuilder(this.name.length() + this.list.size() * 10);
        builder.append(this.name).append(" (");
        boolean first = true;
        for (Pair<String, Object> pair : this.list) {
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append(pair.getLeft()).append('=');
            if (pair.getRight() != null && pair.getRight().getClass().isArray()) {
                String arr = Arrays.deepToString(new Object[]{pair.getRight()});
                builder.append(arr, 1, arr.length() - 1);
                continue;
            }
            builder.append(pair.getRight());
        }
        builder.append(')');
        return builder.toString();
    }
}

