/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.DefaultVersionListener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.TwitchDelaySender;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.TwitchListener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.TwitchVersionListener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Badges;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BanDuration;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BanReason;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Bits;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.BroadcasterLang;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Color;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.DisplayName;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.EmoteSets;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Emotes;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Id;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Mod;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamMonths;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamSubPlan;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.MsgParamSubPlanName;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.R9k;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.RoomId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Slow;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.SubsOnly;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Subscriber;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.SystemMsg;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.Turbo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.UserId;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.twitch.messagetag.UserType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class TwitchSupport {
    public static final String CAPABILITY_COMMANDS = "twitch.tv/commands";
    public static final String CAPABILITY_MEMBERSHIP = "twitch.tv/membership";
    public static final String CAPABILITY_TAGS = "twitch.tv/tags";

    public static Client addSupport(@NonNull Client client) {
        return TwitchSupport.addSupport(client, false);
    }

    public static Client addSupport(@NonNull Client client, boolean alwaysModOrOp) {
        Sanity.truthiness(!((Client.WithManagement)client).isConnectionAlive(), "Client already connected!");
        client.getEventManager().getRegisteredEventListeners().stream().filter(l -> l.getClass().equals(DefaultVersionListener.class)).forEach(client.getEventManager()::unregisterEventListener);
        client.getEventManager().registerEventListener(new TwitchListener(client));
        client.getEventManager().registerEventListener(new TwitchVersionListener((Client.WithManagement)client));
        client.setMessageSendingQueueSupplier(TwitchDelaySender.getSupplier(alwaysModOrOp));
        ((Client.WithManagement)client).getActorTracker().setQueryChannelInformation(false);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "badges", Badges.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "ban-duration", BanDuration.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "ban-reason", BanReason.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "bits", Bits.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "broadcaster-lang", BroadcasterLang.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "color", Color.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "display-name", DisplayName.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "emotes", Emotes.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "emote-sets", EmoteSets.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "id", Id.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-id", MsgId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-months", MsgParamMonths.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-sub-plan", MsgParamSubPlan.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "msg-param-sub-plan-name", MsgParamSubPlanName.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "mod", Mod.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "r9k", R9k.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "room-id", RoomId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "slow", Slow.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "subs-only", SubsOnly.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "subscriber", Subscriber.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "system-msg", SystemMsg.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "turbo", Turbo.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user", User.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user-id", UserId.FUNCTION);
        client.getMessageTagManager().registerTagCreator(CAPABILITY_TAGS, "user-type", UserType.FUNCTION);
        return client;
    }

    public static boolean hasSupport(@NonNull Client client) {
        return client.getEventManager().getRegisteredEventListeners().stream().anyMatch(l -> l.getClass().equals(TwitchVersionListener.class));
    }

    private TwitchSupport() {
    }
}

