/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsClientState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsPolicy;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.HostWithPort;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;

public class MemoryStsMachine
implements StsMachine {
    private final StsStorageManager manager;
    private final Client.WithManagement client;
    private StsClientState state = StsClientState.UNKNOWN;
    private StsPolicy policy;

    public MemoryStsMachine(@NonNull StsStorageManager manager, Client.WithManagement client) {
        this.client = Sanity.nullCheck(client, "Cannot have a null client.");
        this.manager = Sanity.nullCheck(manager, "Cannot have a null STS persistence manager.");
    }

    @Override
    public @NonNull StsClientState getCurrentState() {
        return this.state;
    }

    @Override
    public void setCurrentState(@NonNull StsClientState newState) {
        this.state = Sanity.nullCheck(newState, "Need a valid state for the state machine.");
        this.step();
    }

    private void step() {
        switch (this.state) {
            case UNKNOWN: {
                throw new IllegalStateException("Unknown state can only be used as an initial state!");
            }
            case STS_POLICY_CACHED: 
            case STS_PRESENT_RECONNECTING: {
                this.client.isSecureConnection();
                HostWithPort oldAddress = this.client.getServerAddress();
                HostWithPort newAddress = HostWithPort.of(oldAddress.getHost(), Integer.parseInt(this.policy.getOptions().getOrDefault("port", "6697")));
                this.client.setServerAddress(newAddress);
                break;
            }
        }
        if (this.state == StsClientState.STS_PRESENT_RECONNECTING) {
            this.client.reconnect();
        }
    }

    @Override
    public @NonNull StsStorageManager getStorageManager() {
        return this.manager;
    }

    @Override
    public void setStsPolicy(@NonNull StsPolicy policy) {
        this.policy = Sanity.nullCheck(policy, "Policy");
    }
}

