/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ServerMessageEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class NickRejectedEvent
extends ServerMessageEventBase {
    private final String attemptedNick;
    private String newNick;

    public NickRejectedEvent(@NonNull Client client, @NonNull ServerMessage sourceMessage, @NonNull String attemptedNick, @NonNull String newNick) {
        super(client, sourceMessage);
        this.attemptedNick = Sanity.nullCheck(attemptedNick, "Attempted nick cannot be null");
        this.newNick = Sanity.nullCheck(newNick, "New nick cannot be null");
    }

    public @NonNull String getAttemptedNick() {
        return this.attemptedNick;
    }

    public @NonNull String getNewNick() {
        return this.newNick;
    }

    public void setNewNick(@NonNull String newNick) {
        Sanity.safeMessageCheck(newNick, "Nick");
        Sanity.truthiness(!newNick.equals(this.attemptedNick), "Cannot set new nick to the currently failing nick");
        Sanity.noSpaces(newNick, "Nick");
        this.newNick = newNick;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("attemptedNick", this.attemptedNick).add("newNick", this.newNick);
    }
}

