/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.event.capabilities;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.abstractbase.ServerMultipleMessageEventBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.helper.CapabilityNegotiationRequestEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class CapabilitiesSupportedListEvent
extends ServerMultipleMessageEventBase
implements CapabilityNegotiationRequestEvent {
    private final List<CapabilityState> supportedCapabilities;
    private final List<String> requests = new ArrayList<String>();
    private boolean endNegotiation = true;
    private final boolean negotiating;

    public CapabilitiesSupportedListEvent(@NonNull Client client, @NonNull List<ServerMessage> sourceMessages, boolean negotiating, @NonNull List<CapabilityState> supportedCapabilities) {
        super(client, sourceMessages);
        this.negotiating = negotiating;
        Sanity.nullCheck(supportedCapabilities, "Capabilities list cannot be null");
        this.supportedCapabilities = Collections.unmodifiableList(new ArrayList<CapabilityState>(supportedCapabilities));
    }

    @Override
    public void addRequest(@NonNull String capability) {
        this.requests.add(Sanity.safeMessageCheck(capability, "capability"));
    }

    @Override
    public @NonNull List<String> getRequests() {
        return Collections.unmodifiableList(new ArrayList<String>(this.requests));
    }

    public @NonNull List<CapabilityState> getSupportedCapabilities() {
        return this.supportedCapabilities;
    }

    @Override
    public final boolean isEndingNegotiation() {
        return this.endNegotiation;
    }

    @Override
    public final boolean isNegotiating() {
        return this.negotiating;
    }

    @Override
    public final void setEndingNegotiation(boolean endNegotiation) {
        this.endNegotiation = endNegotiation;
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("requests", this.requests).add("supportedCapabilities", this.supportedCapabilities).add("isEndingNegotiation", this.endNegotiation).add("isNegotiating", this.isNegotiating());
    }
}

