/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.creeperhost.minetogether.net.engio.mbassy.listener.Handler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.listener.AbstractDefaultListenerBase;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ServerMessage;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelUserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.channel.ChannelUsersUpdatedEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.event.client.ClientReceiveNumericEvent;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.filter.NumericFilter;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultWhoListener
extends AbstractDefaultListenerBase {
    private final List<ServerMessage> whoMessages = new ArrayList<ServerMessage>();

    public DefaultWhoListener( @NonNull Client.WithManagement client) {
        super(client);
    }

    @NumericFilter.Numerics(value={@NumericFilter(value=352), @NumericFilter(value=354)})
    @Handler(priority=0x7FFFFFFE)
    public void who(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < (event.getNumeric() == 352 ? 8 : 9)) {
            this.trackException(event, "WHO response too short");
            return;
        }
        Optional<Channel> channel = this.getTracker().getChannel(event.getParameters().get(1));
        channel.ifPresent(ch -> {
            String realName;
            String ident = event.getParameters().get(2);
            String host = event.getParameters().get(3);
            String server = event.getParameters().get(4);
            String nick = event.getParameters().get(5);
            User user = (User)this.getTracker().getActor(nick + '!' + ident + '@' + host);
            this.getTracker().trackUser(user);
            this.getTracker().setUserServer(nick, server);
            String status = event.getParameters().get(6);
            switch (event.getNumeric()) {
                case 352: {
                    realName = event.getParameters().get(7);
                    break;
                }
                default: {
                    String account = event.getParameters().get(7);
                    this.getTracker().setUserAccount(nick, "0".equals(account) ? null : account);
                    realName = event.getParameters().get(8);
                }
            }
            this.getTracker().setUserRealName(nick, realName);
            HashSet<ChannelUserMode> modes = new HashSet<ChannelUserMode>();
            block3: for (char prefix : status.substring(1).toCharArray()) {
                if (prefix == 'G') {
                    this.getTracker().setUserAway(nick, true);
                    continue;
                }
                if (prefix == '*') {
                    this.getTracker().setUserOperString(nick, "*");
                    continue;
                }
                for (ChannelUserMode mode : this.getClient().getServerInfo().getChannelUserModes()) {
                    if (mode.getNickPrefix() != prefix) continue;
                    modes.add(mode);
                    continue block3;
                }
            }
            this.getTracker().trackChannelUser(ch.getName(), user, modes);
            this.whoMessages.add(event.getServerMessage());
        });
    }

    @NumericFilter(value=315)
    @Handler(priority=0x7FFFFFFE)
    public void whoComplete(ClientReceiveNumericEvent event) {
        if (event.getParameters().size() < 2) {
            this.trackException(event, "WHO response too short");
            return;
        }
        Optional<Channel> whoChannel = this.getTracker().getChannel(event.getParameters().get(1));
        whoChannel.ifPresent(channel -> {
            this.getTracker().setChannelListReceived(channel.getName());
            this.whoMessages.add(event.getServerMessage());
            this.fire(new ChannelUsersUpdatedEvent(this.getClient(), this.whoMessages, (Channel)channel));
            this.whoMessages.clear();
        });
    }
}

