/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Map;
import java.util.Optional;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SimpleDefaultMessageMap
implements DefaultMessageMap {
    protected final Map<DefaultMessageType, String> defaults = new EnumMap<DefaultMessageType, String>(DefaultMessageType.class);

    public SimpleDefaultMessageMap(@Nullable String defaultString) {
        for (DefaultMessageType defaultMessageType : DefaultMessageType.values()) {
            this.defaults.put(defaultMessageType, defaultString);
        }
    }

    public SimpleDefaultMessageMap() {
    }

    @Override
    public @NonNull SimpleDefaultMessageMap setDefault(@NonNull DefaultMessageType key, @Nullable String defaultString) {
        this.defaults.put(Sanity.nullCheck(key, "Key"), defaultString);
        return this;
    }

    @Override
    public @NonNull Optional<String> getDefault(DefaultMessageType key) {
        return this.getDefault(Sanity.nullCheck(key, "Key"), key.getFallback());
    }

    @Override
    public @NonNull Optional<String> getDefault(@NonNull DefaultMessageType key, @Nullable String defaultValue) {
        Sanity.nullCheck(key, "Key");
        return Optional.ofNullable(this.defaults.getOrDefault((Object)key, defaultValue));
    }

    @Override
    public @NonNull Map<DefaultMessageType, String> getDefaults() {
        return Collections.unmodifiableMap(new EnumMap<DefaultMessageType, String>(this.defaults));
    }
}

