/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.feature;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.CapabilityState;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class DefaultCapabilityManager
implements CapabilityManager.WithManagement {
    private final Client client;
    private final Map<String, CapabilityState> capabilities = new ConcurrentHashMap<String, CapabilityState>();
    private List<CapabilityState> supportedCapabilities = new ArrayList<CapabilityState>();
    private boolean negotiating = true;

    public DefaultCapabilityManager(Client client) {
        this.client = client;
    }

    @Override
    public void reset() {
        this.capabilities.clear();
        this.negotiating = true;
    }

    @Override
    public @NonNull List<CapabilityState> getCapabilities() {
        return new ArrayList<CapabilityState>(this.capabilities.values());
    }

    @Override
    public @NonNull List<CapabilityState> getSupportedCapabilities() {
        return new ArrayList<CapabilityState>(this.supportedCapabilities);
    }

    @Override
    public boolean isNegotiating() {
        return this.negotiating;
    }

    @Override
    public void endNegotiation() {
        this.negotiating = false;
    }

    @Override
    public void updateCapabilities(@NonNull List<CapabilityState> capabilityStates) {
        for (CapabilityState capabilityState : capabilityStates) {
            if (capabilityState.isDisabled()) {
                this.capabilities.remove(capabilityState.getName());
                continue;
            }
            this.capabilities.put(capabilityState.getName(), capabilityState);
        }
    }

    @Override
    public void setCapabilities(@NonNull List<CapabilityState> capabilityStates) {
        this.capabilities.clear();
        this.updateCapabilities(capabilityStates);
    }

    @Override
    public void setSupportedCapabilities(@NonNull List<CapabilityState> capabilityStates) {
        this.supportedCapabilities = new ArrayList<CapabilityState>(capabilityStates);
    }

    public @NonNull String toString() {
        return new ToStringer(this).add("client", this.client).add("capabilities", this.capabilities).add("supportedCapabilities", this.supportedCapabilities).toString();
    }
}

