/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.isupport.DefaultISupportParameterValueRequired;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.element.mode.DefaultChannelMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ISupportParameter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ChannelMode;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultISupportChanModes
extends DefaultISupportParameterValueRequired
implements ISupportParameter.ChanModes {
    private final List<ChannelMode> modes;

    public DefaultISupportChanModes(@NonNull Client client, @NonNull String name, @Nullable String value) {
        super(client, name, value);
        String[] modes = value.split(",");
        ArrayList<DefaultChannelMode> modesList = new ArrayList<DefaultChannelMode>();
        for (int typeId = 0; typeId < modes.length && typeId < 4; ++typeId) {
            for (char mode : modes[typeId].toCharArray()) {
                ChannelMode.Type type;
                switch (typeId) {
                    case 0: {
                        type = ChannelMode.Type.A_MASK;
                        break;
                    }
                    case 1: {
                        type = ChannelMode.Type.B_PARAMETER_ALWAYS;
                        break;
                    }
                    case 2: {
                        type = ChannelMode.Type.C_PARAMETER_ON_SET;
                        break;
                    }
                    default: {
                        type = ChannelMode.Type.D_PARAMETER_NEVER;
                    }
                }
                modesList.add(new DefaultChannelMode(client, mode, type));
            }
        }
        this.modes = Collections.unmodifiableList(modesList);
    }

    @Override
    public @NonNull List<ChannelMode> getModes() {
        return this.modes;
    }
}

