/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library.command;

import net.creeperhost.minetogether.org.kitteh.irc.client.library.Client;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.Command;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.ToStringer;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OperCommand
extends Command<OperCommand> {
    private String user;
    private String password;

    public OperCommand(@NonNull Client client) {
        super(client);
    }

    public @NonNull OperCommand user(@NonNull String user) {
        this.user = Sanity.safeMessageCheck(user, "user");
        return this;
    }

    public @NonNull OperCommand password(@NonNull String password) {
        this.password = Sanity.safeMessageCheck(password, "password");
        return this;
    }

    @Override
    public void execute() {
        if (this.user == null) {
            throw new IllegalStateException("User not defined");
        }
        if (this.password == null) {
            throw new IllegalStateException("Password not defined");
        }
        this.sendCommandLine("OPER " + this.user + ' ' + this.password);
    }

    @Override
    protected @NonNull ToStringer toStringer() {
        return super.toStringer().add("user", this.user == null ? null : "AzureDiamond").add("password", this.password == null ? null : "hunter2");
    }
}

