/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.org.kitteh.irc.client.library;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.net.ssl.TrustManagerFactory;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.AwayCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.CapabilityRequestCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.ChannelModeCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.KickCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.MonitorCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.OperCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.TopicCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WallopsCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.command.WhoisCommand;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.defaults.DefaultBuilder;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.Channel;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.ClientLinked;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.MessageReceiver;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.User;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.ModeStatusList;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.element.mode.UserMode;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ActorTracker;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.AuthManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.CapabilityManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventListenerSupplier;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.EventManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ISupportManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.MessageTagManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.ServerInfo;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.defaultmessage.DefaultMessageMap;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.network.NetworkHandler;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.network.ProxyType;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sending.MessageSendingQueue;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsMachine;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.feature.sts.StsStorageManager;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Cutter;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.HostWithPort;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Listener;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Pair;
import net.creeperhost.minetogether.org.kitteh.irc.client.library.util.Sanity;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Client
extends ClientLinked {
    public static @NonNull Builder builder() {
        return new DefaultBuilder();
    }

    public void addChannel(String ... var1);

    public void addKeyProtectedChannel(@NonNull String var1, @NonNull String var2);

    public void addKeyProtectedChannel(Pair<String, String> ... var1);

    public @NonNull Commands commands();

    public @NonNull AuthManager getAuthManager();

    public @NonNull CapabilityManager getCapabilityManager();

    public @NonNull Optional<Channel> getChannel(@NonNull String var1);

    public @NonNull Set<Channel> getChannels();

    public @NonNull Set<Channel> getChannels(@NonNull Collection<String> var1);

    public @NonNull DefaultMessageMap getDefaultMessageMap();

    public @NonNull EventManager getEventManager();

    public @NonNull Listener<Exception> getExceptionListener();

    public @NonNull String getIntendedNick();

    public @NonNull Optional<StsMachine> getStsMachine();

    public @NonNull ISupportManager getISupportManager();

    public @NonNull Cutter getMessageCutter();

    public @NonNull Function<WithManagement, ? extends MessageSendingQueue> getMessageSendingQueueSupplier();

    public @NonNull MessageTagManager getMessageTagManager();

    public @NonNull String getName();

    public @NonNull String getNick();

    public @NonNull ServerInfo getServerInfo();

    public @NonNull Optional<User> getUser();

    public @NonNull Optional<ModeStatusList<UserMode>> getUserModes();

    default public boolean isUser(@Nullable User user) {
        return user != null && user.equals(this.getUser().orElse(null));
    }

    public void knockChannel(@NonNull String var1);

    public void reconnect();

    public void reconnect(@Nullable String var1);

    public void removeChannel(@NonNull String var1);

    public void removeChannel(@NonNull String var1, @Nullable String var2);

    public void sendCtcpMessage(@NonNull String var1, @NonNull String var2);

    default public void sendCtcpMessage(@NonNull MessageReceiver target, @NonNull String message) {
        Sanity.nullCheck(target, "Target");
        this.sendCtcpMessage(target.getMessagingName(), message);
    }

    public void sendCtcpReply(@NonNull String var1, @NonNull String var2);

    default public void sendCtcpReply(@NonNull MessageReceiver target, @NonNull String message) {
        Sanity.nullCheck(target, "Target");
        this.sendCtcpMessage(target.getMessagingName(), message);
    }

    public void sendMessage(@NonNull String var1, @NonNull String var2);

    default public void sendMessage(@NonNull MessageReceiver target, @NonNull String message) {
        Sanity.nullCheck(target, "Target");
        this.sendMessage(target.getMessagingName(), message);
    }

    public void sendNotice(@NonNull String var1, @NonNull String var2);

    default public void sendNotice(@NonNull MessageReceiver target, @NonNull String message) {
        Sanity.nullCheck(target, "Target");
        this.sendNotice(target.getMessagingName(), message);
    }

    default public void sendMultiLineMessage(@NonNull String target, @NonNull String message) {
        this.sendMultiLineMessage(target, message, this.getMessageCutter());
    }

    public void sendMultiLineMessage(@NonNull String var1, @NonNull String var2, @NonNull Cutter var3);

    default public void sendMultiLineMessage(@NonNull MessageReceiver target, @NonNull String message) {
        this.sendMultiLineMessage(target, message, this.getMessageCutter());
    }

    default public void sendMultiLineMessage(@NonNull MessageReceiver target, @NonNull String message, @NonNull Cutter cutter) {
        Sanity.nullCheck(target, "Target");
        this.sendMultiLineMessage(target.getMessagingName(), message, cutter);
    }

    default public void sendMultiLineNotice(@NonNull String target, @NonNull String message) {
        this.sendMultiLineNotice(target, message, this.getMessageCutter());
    }

    public void sendMultiLineNotice(@NonNull String var1, @NonNull String var2, @NonNull Cutter var3);

    default public void sendMultiLineNotice(@NonNull MessageReceiver target, @NonNull String message) {
        this.sendMultiLineNotice(target, message, this.getMessageCutter());
    }

    default public void sendMultiLineNotice(@NonNull MessageReceiver target, @NonNull String message, @NonNull Cutter cutter) {
        Sanity.nullCheck(target, "Target");
        this.sendMultiLineNotice(target.getMessagingName(), message, cutter);
    }

    public void sendRawLine(@NonNull String var1);

    public void sendRawLineAvoidingDuplication(@NonNull String var1);

    public void sendRawLineImmediately(@NonNull String var1);

    public void setExceptionListener(@Nullable Consumer<Exception> var1);

    public void setDefaultMessageMap(@NonNull DefaultMessageMap var1);

    public void setInputListener(@Nullable Consumer<String> var1);

    public void setMessageCutter(@NonNull Cutter var1);

    public void setMessageSendingQueueSupplier(@NonNull Function<WithManagement, ? extends MessageSendingQueue> var1);

    public void setNick(@NonNull String var1);

    public void setOutputListener(@Nullable Consumer<String> var1);

    public void connect();

    public void shutdown();

    public void shutdown(@Nullable String var1);

    @Override
    default public @NonNull Client getClient() {
        return this;
    }

    public static interface WithManagement
    extends Client {
        public void beginMessageSendingImmediate(@NonNull Consumer<String> var1);

        public @NonNull ActorTracker getActorTracker();

        public boolean isConnectionAlive();

        public @NonNull InetSocketAddress getBindAddress();

        @Override
        public @NonNull CapabilityManager.WithManagement getCapabilityManager();

        public @NonNull Listener<String> getInputListener();

        public @NonNull Set<String> getIntendedChannels();

        public @NonNull NetworkHandler getNetworkHandler();

        public @NonNull Listener<String> getOutputListener();

        public @NonNull Optional<ProxyType> getProxyType();

        public @NonNull Optional<HostWithPort> getProxyAddress();

        public @NonNull String getRequestedNick();

        public @Nullable Path getSecureKey();

        public @Nullable Path getSecureKeyCertChain();

        public @Nullable String getSecureKeyPassword();

        public @Nullable TrustManagerFactory getSecureTrustManagerFactory();

        public @NonNull HostWithPort getServerAddress();

        @Override
        public @NonNull ServerInfo.WithManagement getServerInfo();

        public void pauseMessageSending();

        public void ping();

        public void processLine(@NonNull String var1);

        public void sendNickChange(@NonNull String var1);

        public void setCurrentNick(@NonNull String var1);

        public void setNetworkHandler(@NonNull NetworkHandler var1);

        public void setServerAddress(@NonNull HostWithPort var1);

        public void initialize(@NonNull String var1, @NonNull NetworkHandler var2, @NonNull HostWithPort var3, @Nullable String var4, @Nullable InetSocketAddress var5, @Nullable HostWithPort var6, @Nullable ProxyType var7, @NonNull String var8, @NonNull String var9, @NonNull String var10, @NonNull ActorTracker var11, @NonNull AuthManager var12, @NonNull CapabilityManager.WithManagement var13, @NonNull EventManager var14, @NonNull List<EventListenerSupplier> var15, @NonNull MessageTagManager var16, @NonNull ISupportManager var17, @Nullable DefaultMessageMap var18, @NonNull Function<WithManagement, ? extends MessageSendingQueue> var19, @NonNull Function<WithManagement, ? extends ServerInfo.WithManagement> var20, @Nullable Consumer<Exception> var21, @Nullable Consumer<String> var22, @Nullable Consumer<String> var23, boolean var24, @Nullable Path var25, @Nullable Path var26, @Nullable String var27, @Nullable TrustManagerFactory var28, @Nullable StsStorageManager var29, @Nullable String var30, @Nullable InetAddress var31, @Nullable String var32, @Nullable String var33);

        public void setUserModes(@NonNull ModeStatusList<UserMode> var1);

        public void startSending();

        public void updateUserModes(@NonNull ModeStatusList<UserMode> var1);

        public boolean isSecureConnection();
    }

    public static interface Commands {
        public @NonNull AwayCommand away();

        public @NonNull CapabilityRequestCommand capabilityRequest();

        public @NonNull ChannelModeCommand mode(@NonNull Channel var1);

        public @NonNull KickCommand kick(@NonNull Channel var1);

        public @NonNull MonitorCommand monitor();

        public @NonNull OperCommand oper();

        public @NonNull TopicCommand topic(@NonNull Channel var1);

        public @NonNull WallopsCommand wallops();

        public @NonNull WhoisCommand whois();
    }

    public static interface Builder {
        public @NonNull Builder name(@NonNull String var1);

        public @NonNull Builder nick(@NonNull String var1);

        public @NonNull Builder user(@NonNull String var1);

        public @NonNull Builder realName(@NonNull String var1);

        public @NonNull Bind bind();

        public @NonNull Server server();

        public @NonNull Listeners listeners();

        public @NonNull Proxy proxy();

        public @NonNull WebIrc.Password webIrc();

        public @NonNull Management management();

        public @NonNull Client build();

        public @NonNull Client buildAndConnect();

        public static interface Management {
            public @NonNull Management actorTracker(@Nullable Function<WithManagement, ? extends ActorTracker> var1);

            public @NonNull Management authManager(@Nullable Function<WithManagement, ? extends AuthManager> var1);

            public @NonNull Management capabilityManager(@Nullable Function<WithManagement, ? extends CapabilityManager.WithManagement> var1);

            public @NonNull Management defaultMessageMap(@Nullable DefaultMessageMap var1);

            public @NonNull Management eventManager(@Nullable Function<WithManagement, ? extends EventManager> var1);

            public @NonNull Management eventListeners(@Nullable List<EventListenerSupplier> var1);

            public @NonNull Management iSupportManager(@Nullable Function<WithManagement, ? extends ISupportManager> var1);

            public @NonNull Management messageSendingQueueSupplier(@Nullable Function<WithManagement, ? extends MessageSendingQueue> var1);

            public @NonNull Management messageTagManager(@Nullable Function<WithManagement, ? extends MessageTagManager> var1);

            public @NonNull Management networkHandler(@NonNull NetworkHandler var1);

            public @NonNull Management serverInfo(@Nullable Function<WithManagement, ? extends ServerInfo.WithManagement> var1);

            public @NonNull Management stsStorageManager(@Nullable StsStorageManager var1);

            public @NonNull Builder then();
        }

        public static interface WebIrc {

            public static interface Ip {
                public @NonNull Builder ip(@Nullable InetAddress var1);
            }

            public static interface Password {
                public @NonNull Gateway password(@Nullable String var1);
            }

            public static interface Gateway {
                public @NonNull Hostname gateway(@Nullable String var1);
            }

            public static interface Hostname {
                public @NonNull Ip hostname(@Nullable String var1);
            }
        }

        public static interface Proxy {
            public @NonNull Proxy proxyHost(String var1);

            public @NonNull Proxy proxyPort(int var1);

            public @NonNull Proxy proxyType(ProxyType var1);

            public @NonNull Builder then();
        }

        public static interface Listeners {
            public @NonNull Listeners input(@Nullable Consumer<String> var1);

            public @NonNull Listeners output(@Nullable Consumer<String> var1);

            public @NonNull Listeners exception(@Nullable Consumer<Exception> var1);

            public @NonNull Builder then();
        }

        public static interface Server {
            public @NonNull Server address(@NonNull HostWithPort var1);

            public @NonNull Server host(@NonNull String var1);

            public @NonNull Server port(int var1);

            public @NonNull Server password(@Nullable String var1);

            public @NonNull Server secure(boolean var1);

            public @NonNull Server secureKeyCertChain(@Nullable Path var1);

            public @NonNull Server secureKey(@Nullable Path var1);

            public @NonNull Server secureKeyPassword(@Nullable String var1);

            public @NonNull Server secureTrustManagerFactory(@Nullable TrustManagerFactory var1);

            public @NonNull Builder then();
        }

        public static interface Bind {
            public @NonNull Bind host(@Nullable String var1);

            public @NonNull Bind port(int var1);

            public @NonNull Builder then();
        }
    }
}

