/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui.element;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;

public class DropdownButton<E extends IDropdownOption>
extends GuiButton {
    public boolean dropdownOpen;
    private E selected;
    private List<E> possibleVals;
    private String baseButtonText;
    private final boolean dynamic;
    public boolean wasJustClosed = false;
    public boolean flipped = false;

    public DropdownButton(int buttonId, int x, int y, int widthIn, int heightIn, String buttonText, E def, boolean dynamic) {
        super(buttonId, x, y, widthIn, heightIn, buttonText);
        this.selected = def;
        this.possibleVals = def.getPossibleVals();
        this.baseButtonText = buttonText;
        this.field_146126_j = I18n.func_135052_a((String)this.baseButtonText, (Object[])new Object[]{I18n.func_135052_a((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[0])});
        this.dynamic = dynamic;
    }

    public DropdownButton(int buttonId, int x, int y, String buttonText, E def, boolean dynamic) {
        this(buttonId, x, y, 200, 20, buttonText, def, dynamic);
    }

    public void func_191745_a(Minecraft mc, int x, int y, float partialTicks) {
        this.realDrawButton(mc, x, y, partialTicks);
    }

    public void func_146112_a(Minecraft mc, int mouseX, int mouseY) {
        this.realDrawButton(mc, mouseX, mouseY, 0.0f);
    }

    public void realDrawButton(Minecraft mc, int x, int y, float partialTicks) {
        if (this.field_146125_m) {
            int drawY = this.field_146129_i;
            FontRenderer fontrenderer = mc.field_71466_p;
            mc.func_110434_K().func_110577_a(field_146122_a);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146123_n = x >= this.field_146128_h && y >= drawY && x < this.field_146128_h + this.field_146120_f && y < drawY + this.field_146121_g;
            int i = this.func_146114_a(this.field_146123_n);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_73729_b(this.field_146128_h, drawY, 0, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, drawY, 200 - this.field_146120_f / 2, 46 + i * 20, this.field_146120_f / 2, this.field_146121_g);
            this.func_146119_b(mc, x, y);
            int j = 0xE0E0E0;
            if (this.packedFGColour != 0) {
                j = this.packedFGColour;
            } else if (!this.field_146124_l) {
                j = 0xA0A0A0;
            } else if (this.field_146123_n) {
                j = 0xFFFFA0;
            }
            this.func_73732_a(fontrenderer, this.field_146126_j, this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + (this.field_146121_g - 8) / 2, j);
            if (this.dropdownOpen) {
                ++drawY;
                int yOffset = this.field_146121_g - 2;
                if (this.flipped) {
                    yOffset = -yOffset;
                    --drawY;
                }
                for (IDropdownOption e : this.possibleVals) {
                    boolean ourHovered = x >= this.field_146128_h && y >= (drawY += yOffset) && x < this.field_146128_h + this.field_146120_f && y < drawY + this.field_146121_g - 2;
                    int subHovered = ourHovered ? 2 : 0;
                    mc.func_110434_K().func_110577_a(field_146122_a);
                    GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    this.func_73729_b(this.field_146128_h, drawY, 0, 46 + subHovered * 20 + 1, this.field_146120_f / 2, this.field_146121_g - 1);
                    this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, drawY, 200 - this.field_146120_f / 2, 46 + subHovered * 20 + 1, this.field_146120_f / 2, this.field_146121_g - 1);
                    String name = I18n.func_135052_a((String)e.getTranslate((IDropdownOption)this.selected, true), (Object[])new Object[0]);
                    int textColour = 0xE0E0E0;
                    if (this.packedFGColour != 0) {
                        textColour = this.packedFGColour;
                    } else if (ourHovered) {
                        textColour = 0xFFFFA0;
                    }
                    this.func_73732_a(fontrenderer, name, this.field_146128_h + this.field_146120_f / 2, drawY + (this.field_146121_g - 10) / 2, textColour);
                }
            }
        }
    }

    protected int func_146114_a(boolean mouseOver) {
        return mouseOver ? 2 : (this.field_146124_l ? (this.dropdownOpen ? 2 : 1) : 0);
    }

    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        boolean pressed = super.func_146116_c(mc, mouseX, mouseY);
        if (this.dropdownOpen) {
            if (pressed) {
                this.close();
                return false;
            }
            E clickedElement = this.getClickedElement(mouseX, mouseY);
            if (clickedElement != null) {
                this.setSelected(clickedElement);
                this.close();
                return true;
            }
            this.close();
            return false;
        }
        if (pressed) {
            this.dropdownOpen = true;
            if (this.dynamic) {
                this.selected.updateDynamic();
                this.possibleVals = this.selected.getPossibleVals();
            }
        }
        return false;
    }

    public void close() {
        this.dropdownOpen = false;
        this.wasJustClosed = true;
    }

    public E getSelected() {
        return this.selected;
    }

    public void setSelected(E selected) {
        try {
            this.selected = selected;
            this.updateDisplayString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateDisplayString() {
        this.field_146126_j = I18n.func_135052_a((String)this.baseButtonText, (Object[])new Object[]{I18n.func_135052_a((String)this.selected.getTranslate((IDropdownOption)this.selected, false), (Object[])new Object[0])});
    }

    private E getClickedElement(int mouseX, int mouseY) {
        IDropdownOption clickedElement = null;
        int y = this.field_146129_i + 1;
        int yOffset = this.field_146121_g - 2;
        if (this.flipped) {
            yOffset = -yOffset;
            --y;
        }
        for (IDropdownOption e : this.possibleVals) {
            if (mouseX < this.field_146128_h || mouseY < (y += yOffset) || mouseX >= this.field_146128_h + this.field_146120_f || mouseY >= y + this.field_146121_g - 2) continue;
            clickedElement = e;
            break;
        }
        return (E)clickedElement;
    }

    public static interface IDropdownOption {
        public List<IDropdownOption> getPossibleVals();

        public String getTranslate(IDropdownOption var1, boolean var2);

        default public void updateDynamic() {
        }
    }
}

