/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.gui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.creeperhost.minetogether.CreeperHost;
import net.creeperhost.minetogether.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiServerInfo
extends GuiScreen {
    boolean isPlayerOpped = true;
    long ticks;
    private String header;

    public static <K, V extends Comparable<? super V>> Map<K, V> sortByValue(Map<K, V> map) {
        LinkedList<Map.Entry<K, V>> list = new LinkedList<Map.Entry<K, V>>(map.entrySet());
        Collections.sort(list, (o1, o2) -> ((Comparable)o2.getValue()).compareTo(o1.getValue()));
        LinkedHashMap result = new LinkedHashMap();
        for (Map.Entry entry : list) {
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void doTick() {
        ++this.ticks;
    }

    /*
     * WARNING - void declaration
     */
    public boolean renderServerInfo() {
        int l3;
        Map<String, Integer> myList = new LinkedHashMap();
        int i = 0;
        int j = 0;
        int k = 0;
        try {
            if (CreeperHost.instance.getQueryGetter().getExtendedServerData() == null) {
                return false;
            }
            Map<String, Double> tpsInfo = CreeperHost.instance.getQueryGetter().getExtendedServerData().getTPS(this.field_146297_k.field_71439_g.field_71093_bK);
            TextFormatting color = TextFormatting.WHITE;
            if (tpsInfo.get("tps") < 20.0) {
                color = TextFormatting.YELLOW;
            }
            if (tpsInfo.get("tps") < 10.0) {
                color = TextFormatting.RED;
            }
            this.header = String.format("%s %s%.2f(%.2f)", Util.localize("gui.tps", new Object[0]), color, tpsInfo.get("tps"), tpsInfo.get("ticktime"));
            Map<String, Integer> entities = CreeperHost.instance.getQueryGetter().getExtendedServerData().getEntitiesInDimension(Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension());
            for (Map.Entry<String, Integer> entity : entities.entrySet()) {
                int keyLength;
                String key = entity.getKey();
                if ((key.length() >= 9 && key.contains("item.tile.") || key.contains("item.item.")) && !(key = key.substring(5)).contains(".name")) {
                    key = key + ".name";
                }
                if ((keyLength = (key = I18n.func_135052_a((String)key, (Object[])new Object[0])).length()) >= 15) {
                    int start;
                    for (int end = 15; end <= keyLength; ++end) {
                        start = end - 15;
                        String subStr = key.substring(start, end);
                        k = this.field_146297_k.field_71466_p.func_78256_a(subStr);
                        i = Math.max(i, k);
                    }
                    int work = keyLength - 15 + 12;
                    start = (int)Math.floor(this.ticks / 20L) % work;
                    start = start <= 5 ? 0 : (start -= 6);
                    if (start + 15 > keyLength) {
                        start = keyLength - 15;
                    }
                    int end = start + 15;
                    key = key.substring(start, end);
                } else {
                    k = this.field_146297_k.field_71466_p.func_78256_a(key);
                    i = Math.max(i, k);
                }
                Double value = (Double)((Object)entity.getValue());
                int finalVal = value.intValue();
                myList.put(key, finalVal);
            }
            myList = GuiServerInfo.sortByValue(myList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (Map.Entry entString : myList.entrySet()) {
            k = this.field_146297_k.field_71466_p.func_78256_a(" " + entString.getValue());
            j = Math.max(j, k);
        }
        int i4 = l3 = Math.min(myList.size(), 60);
        int j4 = 1;
        while (i4 > 20) {
            i4 = (l3 + ++j4 - 1) / j4;
        }
        int l = j;
        int i1 = Math.min(j4 * (0 + i + l), this.field_146294_l - 50) / j4;
        int j1 = this.field_146294_l / 2 - (i1 * j4 + (j4 - 1) * 5) / 2;
        int k1 = 10;
        int l1 = i1 * j4 + (j4 - 1) * 5;
        ArrayList<String> list1 = null;
        if (this.header != null) {
            list1 = this.field_146297_k.field_71466_p.func_78271_c(this.header, this.field_146294_l - 50);
            list1 = new ArrayList<String>(list1);
            list1.add(Util.localize("gui.entities", new Object[0]));
            for (String string : list1) {
                l1 = Math.max(l1, this.field_146297_k.field_71466_p.func_78256_a(string));
            }
        }
        List list2 = null;
        if (list1 != null) {
            GuiServerInfo.func_73734_a((int)(this.field_146294_l / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(this.field_146294_l / 2 + l1 / 2 + 1), (int)(k1 + list1.size() * this.field_146297_k.field_71466_p.field_78288_b), (int)Integer.MIN_VALUE);
            for (String s2 : list1) {
                int i2 = this.field_146297_k.field_71466_p.func_78256_a(s2);
                this.field_146297_k.field_71466_p.func_175063_a(s2, (float)(this.field_146294_l / 2 - i2 / 2), (float)k1, -1);
                k1 += this.field_146297_k.field_71466_p.field_78288_b;
            }
            ++k1;
        }
        GuiServerInfo.func_73734_a((int)(this.field_146294_l / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(this.field_146294_l / 2 + l1 / 2 + 1), (int)(k1 + i4 * 9), (int)Integer.MIN_VALUE);
        boolean bl = false;
        for (Map.Entry entString : myList.entrySet()) {
            void var15_32;
            if (var15_32 == 60) break;
            void l4 = var15_32 / i4;
            void i5 = var15_32 % i4;
            int j2 = j1 + l4 * i1 + l4 * 5;
            int k2 = k1 + i5 * 9;
            GuiServerInfo.func_73734_a((int)j2, (int)k2, (int)(j2 + i1), (int)(k2 + 8), (int)0x20FFFFFF);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179141_d();
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            if (var15_32 < myList.size()) {
                String s4 = (String)entString.getKey();
                this.field_146297_k.field_71466_p.func_175063_a(s4, (float)j2, (float)k2, -1);
                int k5 = j2 + i + 1;
                int l5 = k5 + l;
                if (l5 - k5 > 5) {
                    String s1 = TextFormatting.YELLOW + "" + entString.getValue();
                    this.field_146297_k.field_71466_p.func_175063_a(s1, (float)(l5 - this.field_146297_k.field_71466_p.func_78256_a(s1)), (float)k2, 0xFFFFFF);
                }
            }
            ++var15_32;
        }
        if (list2 != null) {
            k1 = k1 + i4 * 9 + 1;
            GuiServerInfo.func_73734_a((int)(this.field_146294_l / 2 - l1 / 2 - 1), (int)(k1 - 1), (int)(this.field_146294_l / 2 + l1 / 2 + 1), (int)(k1 + list2.size() * this.field_146297_k.field_71466_p.field_78288_b), (int)Integer.MIN_VALUE);
            for (String s3 : list2) {
                int j5 = this.field_146297_k.field_71466_p.func_78256_a(s3);
                this.field_146297_k.field_71466_p.func_175063_a(s3, (float)(this.field_146294_l / 2 - j5 / 2), (float)k1, -1);
                k1 += this.field_146297_k.field_71466_p.field_78288_b;
            }
        }
        return true;
    }

    public boolean getIsPlayerOpped() {
        return this.isPlayerOpped;
    }
}

