/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.network.packets;

import io.netty.buffer.ByteBuf;
import ipsis.woot.client.gui.inventory.FactoryHeartContainer;
import ipsis.woot.multiblock.EnumMobFactoryTier;
import ipsis.woot.oss.NetworkTools;
import ipsis.woot.tileentity.ui.FarmUIInfo;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketFarmInfo
implements IMessage {
    private FarmUIInfo farmUIInfo;

    public void fromBytes(ByteBuf buf) {
        this.farmUIInfo = new FarmUIInfo();
        this.farmUIInfo.isValid = true;
        this.farmUIInfo.recipeTotalPower = buf.readLong();
        this.farmUIInfo.recipePowerPerTick = buf.readInt();
        this.farmUIInfo.recipeTotalTime = buf.readInt();
        this.farmUIInfo.mobCount = buf.readInt();
        this.farmUIInfo.isRunning = buf.readBoolean();
        this.farmUIInfo.tier = EnumMobFactoryTier.getTier(buf.readByte());
        this.farmUIInfo.powerStored = buf.readInt();
        this.farmUIInfo.powerCapacity = buf.readInt();
        this.farmUIInfo.missingIngredients = buf.readBoolean();
        this.farmUIInfo.mobName = NetworkTools.readString(buf);
        int drops = buf.readInt();
        for (int i = 0; i < drops; ++i) {
            this.farmUIInfo.drops.add(NetworkTools.readItemStack(buf));
        }
        int itemIngredients = buf.readInt();
        for (int i = 0; i < itemIngredients; ++i) {
            ItemStack itemStack = NetworkTools.readItemStack(buf);
            if (itemStack.func_190926_b()) continue;
            this.farmUIInfo.ingredientsItems.add(itemStack);
        }
        int fluidIngredients = buf.readInt();
        for (int i = 0; i < fluidIngredients; ++i) {
            FluidStack fluidStack = ipsis.woot.util.NetworkTools.readFluidStack(buf);
            if (fluidStack == null) continue;
            this.farmUIInfo.ingredientsFluids.add(fluidStack);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.farmUIInfo.recipeTotalPower);
        buf.writeInt(this.farmUIInfo.recipePowerPerTick);
        buf.writeInt(this.farmUIInfo.recipeTotalTime);
        buf.writeInt(this.farmUIInfo.mobCount);
        buf.writeBoolean(this.farmUIInfo.isRunning);
        buf.writeByte(this.farmUIInfo.tier.ordinal());
        buf.writeInt(this.farmUIInfo.powerStored);
        buf.writeInt(this.farmUIInfo.powerCapacity);
        buf.writeBoolean(this.farmUIInfo.missingIngredients);
        NetworkTools.writeString(buf, this.farmUIInfo.mobName);
        buf.writeInt(this.farmUIInfo.drops.size());
        for (ItemStack itemStack : this.farmUIInfo.drops) {
            NetworkTools.writeItemStack(buf, itemStack);
        }
        buf.writeInt(this.farmUIInfo.ingredientsItems.size());
        for (ItemStack itemStack : this.farmUIInfo.ingredientsItems) {
            NetworkTools.writeItemStack(buf, itemStack);
        }
        buf.writeInt(this.farmUIInfo.ingredientsFluids.size());
        for (FluidStack fluidStack : this.farmUIInfo.ingredientsFluids) {
            ipsis.woot.util.NetworkTools.writeFluidStack(buf, fluidStack);
        }
    }

    public PacketFarmInfo() {
    }

    public PacketFarmInfo(FarmUIInfo farmUIInfo) {
        this.farmUIInfo = farmUIInfo;
    }

    public static class Handler
    implements IMessageHandler<PacketFarmInfo, IMessage> {
        public IMessage onMessage(PacketFarmInfo message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketFarmInfo pkt, MessageContext ctx) {
            EntityPlayerSP player = FMLClientHandler.instance().getClient().field_71439_g;
            if (player != null && player.field_71070_bA != null && player.field_71070_bA instanceof FactoryHeartContainer) {
                ((FactoryHeartContainer)player.field_71070_bA).handleFarmInfo(pkt.farmUIInfo);
            }
        }
    }
}

