/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.config.ConfigGroup;
import com.feed_the_beast.ftblib.lib.config.IConfigCallback;
import com.feed_the_beast.ftblib.lib.data.FTBLibAPI;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.BarrelContentType;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.block.Tier;
import com.latmod.yabba.item.upgrade.ItemUpgradeTier;
import com.latmod.yabba.tile.BarrelContent;
import com.latmod.yabba.tile.IBarrelBlock;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class Barrel
implements IConfigCallback {
    public final IBarrelBlock block;
    private Tier tier;
    private boolean locked;
    private BarrelLook look;
    private final UpgradeData[] upgrades;
    public boolean alwaysDisplayData;
    public boolean displayBar;
    private Boolean isCreative;
    public final BarrelContent content;

    public Barrel(IBarrelBlock b, BarrelContentType c) {
        this.block = b;
        this.tier = null;
        this.locked = false;
        this.look = BarrelLook.DEFAULT;
        this.upgrades = new UpgradeData[8];
        this.alwaysDisplayData = false;
        this.displayBar = false;
        this.isCreative = null;
        this.content = c.function.apply(this);
    }

    public void writeData(NBTTagCompound nbt) {
        this.content.writeData(nbt);
        NBTTagList nbt1 = new NBTTagList();
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null) continue;
            NBTTagCompound nbt2 = this.upgrades[i].stack.serializeNBT();
            nbt2.func_74774_a("Slot", (byte)i);
            nbt1.func_74742_a((NBTBase)nbt2);
        }
        if (!nbt1.func_82582_d()) {
            nbt.func_74782_a("Upgrades", (NBTBase)nbt1);
        }
        if (this.locked) {
            nbt.func_74757_a("Locked", true);
        }
        if (!this.look.model.isDefault()) {
            nbt.func_74778_a("Model", this.look.model.getNBTName());
        }
        if (!this.look.skin.isEmpty()) {
            nbt.func_74778_a("Skin", this.look.skin);
        }
        if (this.alwaysDisplayData) {
            nbt.func_74757_a("AlwaysDisplayData", true);
        }
        if (this.displayBar) {
            nbt.func_74757_a("DisplayBar", true);
        }
    }

    public void readData(NBTTagCompound nbt) {
        int i;
        this.locked = nbt.func_74767_n("Locked");
        this.content.readData(nbt);
        Arrays.fill(this.upgrades, null);
        NBTBase upgradeTag = nbt.func_74781_a("Upgrades");
        if (upgradeTag instanceof NBTTagList) {
            NBTTagList l = (NBTTagList)upgradeTag;
            for (i = 0; i < l.func_74745_c(); ++i) {
                ItemStack stack;
                UpgradeData data;
                NBTTagCompound nbt1 = l.func_150305_b(i);
                byte s = nbt1.func_74771_c("Slot");
                if (s < 0 || s >= this.upgrades.length || (data = (UpgradeData)(stack = new ItemStack(nbt1)).getCapability(UpgradeData.CAPABILITY, null)) == null) continue;
                this.upgrades[s] = data;
            }
        } else if (upgradeTag instanceof NBTTagCompound) {
            for (String s : ((NBTTagCompound)upgradeTag).func_150296_c()) {
                Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(s));
                if (item == null) continue;
                int slot = this.findFreeUpgradeSlot();
                if (slot != -1) {
                    ItemStack stack = new ItemStack(item);
                    UpgradeData data = (UpgradeData)stack.getCapability(UpgradeData.CAPABILITY, null);
                    if (data != null) {
                        data.deserializeNBT(((NBTTagCompound)upgradeTag).func_74775_l(s));
                    }
                    this.upgrades[slot] = data;
                    continue;
                }
                break;
            }
        }
        if (nbt.func_74764_b("Tier")) {
            String stier = nbt.func_74779_i("Tier");
            this.tier = (Tier)((Object)Tier.NAME_MAP.get(stier));
            if (stier.equals("creative")) {
                this.tier = Tier.WOOD;
                i = this.findFreeUpgradeSlot();
                if (i != -1) {
                    this.upgrades[i] = (UpgradeData)new ItemStack(YabbaItems.UPGRADE_CREATIVE).getCapability(UpgradeData.CAPABILITY, null);
                    this.locked = false;
                    this.content.onCreativeChange();
                }
            }
            if (this.tier.tier >= Tier.IRON.tier && (i = this.findFreeUpgradeSlot()) != -1) {
                this.upgrades[i] = (UpgradeData)new ItemStack(YabbaItems.UPGRADE_IRON_TIER).getCapability(UpgradeData.CAPABILITY, null);
            }
            if (this.tier.tier >= Tier.GOLD.tier && (i = this.findFreeUpgradeSlot()) != -1) {
                this.upgrades[i] = (UpgradeData)new ItemStack(YabbaItems.UPGRADE_GOLD_TIER).getCapability(UpgradeData.CAPABILITY, null);
            }
            if (this.tier.tier >= Tier.DIAMOND.tier && (i = this.findFreeUpgradeSlot()) != -1) {
                this.upgrades[i] = (UpgradeData)new ItemStack(YabbaItems.UPGRADE_DIAMOND_TIER).getCapability(UpgradeData.CAPABILITY, null);
            }
            if (this.tier.tier >= Tier.STAR.tier && (i = this.findFreeUpgradeSlot()) != -1) {
                this.upgrades[i] = (UpgradeData)new ItemStack(YabbaItems.UPGRADE_STAR_TIER).getCapability(UpgradeData.CAPABILITY, null);
            }
            this.tier = null;
        }
        this.look = BarrelLook.get(EnumBarrelModel.getFromNBTName(nbt.func_74779_i("Model")), nbt.func_74779_i("Skin"));
        this.alwaysDisplayData = nbt.func_74767_n("AlwaysDisplayData");
        this.displayBar = nbt.func_74767_n("DisplayBar");
    }

    public int findFreeUpgradeSlot() {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] != null) continue;
            return i;
        }
        return -1;
    }

    public Tier getTier() {
        if (this.tier == null) {
            this.tier = Tier.WOOD;
            for (UpgradeData upgrade : this.upgrades) {
                if (upgrade == null || !(upgrade.stack.func_77973_b() instanceof ItemUpgradeTier)) continue;
                Tier t = ((ItemUpgradeTier)upgrade.stack.func_77973_b()).tier;
                if (t.tier <= this.tier.tier) continue;
                this.tier = t;
            }
        }
        return this.tier;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean v) {
        if (this.locked != v) {
            this.locked = v;
            this.block.markBarrelDirty(true);
        }
    }

    public BarrelLook getLook() {
        return this.look;
    }

    public void setLook(BarrelLook l) {
        if (!this.look.equals(l)) {
            this.look = l;
            this.block.markBarrelDirty(true);
        }
    }

    public int getUpgradeCount() {
        return this.upgrades.length;
    }

    @Nullable
    public UpgradeData getUpgrade(int slot) {
        return slot >= 0 && slot < this.upgrades.length ? this.upgrades[slot] : null;
    }

    @Nullable
    public UpgradeData getUpgradeData(Item upgradeItem) {
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null || this.upgrades[i].stack.func_77973_b() != upgradeItem) continue;
            return this.upgrades[i];
        }
        return null;
    }

    public boolean hasUpgrade(Item upgradeItem) {
        return this.getUpgradeData(upgradeItem) != null;
    }

    public void setUpgrade(int slot, @Nullable UpgradeData upgrade) {
        if (slot >= 0 && slot < this.upgrades.length) {
            this.upgrades[slot] = upgrade;
            this.block.markBarrelDirty(true);
        }
    }

    public boolean isCreative() {
        if (this.isCreative == null) {
            this.isCreative = false;
            for (UpgradeData upgrade : this.upgrades) {
                if (upgrade == null || upgrade.stack.func_77973_b() != YabbaItems.UPGRADE_CREATIVE) continue;
                this.isCreative = true;
                return true;
            }
        }
        return this.isCreative;
    }

    public void openGui(EntityPlayerMP player) {
        ConfigGroup config = ConfigGroup.newGroup((String)"barrel_config");
        config.setDisplayName((ITextComponent)new TextComponentString("YABBA"));
        if (!this.isCreative()) {
            config.addBool("locked", () -> this.locked, v -> {
                this.locked = v;
            }, false);
        }
        config.addBool("always_display_data", () -> this.alwaysDisplayData, v -> {
            this.alwaysDisplayData = v;
        }, false).setDisplayName((ITextComponent)new TextComponentTranslation("yabba_client.general.always_display_data", new Object[0]));
        config.addBool("display_bar", () -> this.displayBar, v -> {
            this.displayBar = v;
        }, false).setDisplayName((ITextComponent)new TextComponentTranslation("yabba_client.general.display_bar", new Object[0]));
        for (int i = 0; i < this.upgrades.length; ++i) {
            if (this.upgrades[i] == null) continue;
            ConfigGroup c = config.getGroup(Integer.toString(i));
            c.setDisplayName((ITextComponent)new TextComponentTranslation(this.upgrades[i].stack.func_77977_a() + ".name", new Object[0]));
            this.upgrades[i].getConfig(this, c);
        }
        FTBLibAPI.editServerConfig((EntityPlayerMP)player, (ConfigGroup)config, (IConfigCallback)this);
    }

    public void onConfigSaved(ConfigGroup group, ICommandSender sender) {
        this.block.markBarrelDirty(true);
    }

    public void clearCache() {
        this.tier = null;
        this.isCreative = null;
        this.content.clearCache();
    }
}

