/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.client;

import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.block.BlockDecorativeBlock;
import com.latmod.yabba.client.BakedBarrelItemModel;
import com.latmod.yabba.client.BakedBarrelModelBase;
import com.latmod.yabba.client.BarrelBlockModelKey;
import com.latmod.yabba.client.BarrelBlockModelVariant;
import com.latmod.yabba.tile.IBakedModelBarrel;
import com.latmod.yabba.util.BarrelLook;
import com.latmod.yabba.util.EnumBarrelModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.property.IExtendedBlockState;

public class BakedBarrelBlockModel
extends BakedBarrelModelBase {
    private final VertexFormat format;
    private final Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter;
    private final Map<EnumBarrelModel, IModel> baseModels;
    private final Map<EnumBarrelModel, IModel> cutoutModels;
    private final Map<BarrelBlockModelKey, BarrelBlockModelVariant> cache;
    private final Map<BarrelLook, BakedBarrelItemModel> itemModels;
    private final ItemOverrideList itemOverrideList = new ItemOverrideList(Collections.emptyList()){

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, @Nullable World world, @Nullable EntityLivingBase entity) {
            BakedBarrelItemModel bakedModel;
            BarrelLook look = BarrelLook.DEFAULT;
            if (BlockUtils.hasData((ItemStack)stack)) {
                NBTTagCompound data = BlockUtils.getData((ItemStack)stack);
                look = BarrelLook.get(EnumBarrelModel.getFromNBTName(data.func_74779_i("Model")), data.func_74779_i("Skin"));
            }
            if ((bakedModel = (BakedBarrelItemModel)BakedBarrelBlockModel.this.itemModels.get(look)) == null) {
                BarrelBlockModelVariant variant = BakedBarrelBlockModel.this.getVariant(new BarrelBlockModelKey(look, EnumFacing.NORTH.func_176736_b()));
                bakedModel = new BakedBarrelItemModel();
                for (int r = 0; r < 7; ++r) {
                    ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
                    quads.addAll(variant.rotations[0][r].solidQuads);
                    quads.addAll(variant.rotations[0][r].cutoutQuads);
                    quads.addAll(variant.rotations[0][r].translucentQuads);
                    bakedModel.quads.add(BakedBarrelBlockModel.optimize(quads));
                }
                BakedBarrelBlockModel.this.itemModels.put(look, bakedModel);
            }
            return bakedModel;
        }
    };

    public BakedBarrelBlockModel(VertexFormat f, Function<ResourceLocation, TextureAtlasSprite> t) {
        this.format = f;
        this.bakedTextureGetter = t;
        this.baseModels = new EnumMap<EnumBarrelModel, IModel>(EnumBarrelModel.class);
        this.cutoutModels = new EnumMap<EnumBarrelModel, IModel>(EnumBarrelModel.class);
        this.cache = new HashMap<BarrelBlockModelKey, BarrelBlockModelVariant>();
        this.itemModels = new HashMap<BarrelLook, BakedBarrelItemModel>();
        for (EnumBarrelModel model : EnumBarrelModel.NAME_MAP) {
            this.baseModels.put(model, ModelLoaderRegistry.getModelOrMissing((ResourceLocation)model.getBaseModel()).uvlock(true));
            if (model.getCutoutModel() == null) continue;
            this.cutoutModels.put(model, ModelLoaderRegistry.getModelOrMissing((ResourceLocation)model.getCutoutModel()).uvlock(true));
        }
    }

    @Override
    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        TileEntity tileEntity;
        if (state == null) {
            return Collections.emptyList();
        }
        IBakedModelBarrel barrel = null;
        if (state instanceof IExtendedBlockState) {
            barrel = (IBakedModelBarrel)((IExtendedBlockState)state).getValue(BlockDecorativeBlock.BARREL);
        }
        TileEntity tileEntity2 = tileEntity = barrel == null ? null : barrel.getBarrelTileEntity();
        if (tileEntity == null) {
            return Collections.emptyList();
        }
        if (side == null) {
            boolean render = false;
            for (EnumFacing side1 : EnumFacing.field_82609_l) {
                if (!state.func_185894_c((IBlockAccess)tileEntity.func_145831_w(), tileEntity.func_174877_v(), side1)) continue;
                render = true;
                break;
            }
            if (!render) {
                return Collections.emptyList();
            }
        }
        EnumFacing facing = barrel.getBarrelRotation();
        BarrelBlockModelVariant variant = this.getVariant(new BarrelBlockModelKey(barrel.getLook(), facing.func_176736_b()));
        BlockRenderLayer layer = MinecraftForgeClient.getRenderLayer();
        if (layer == BlockRenderLayer.SOLID) {
            return variant.rotations[facing.func_176734_d().func_176736_b()][side == null ? 6 : side.func_176745_a()].solidQuads;
        }
        if (layer == BlockRenderLayer.CUTOUT) {
            return variant.rotations[facing.func_176734_d().func_176736_b()][side == null ? 6 : side.func_176745_a()].cutoutQuads;
        }
        if (layer == BlockRenderLayer.TRANSLUCENT) {
            return variant.rotations[facing.func_176734_d().func_176736_b()][side == null ? 6 : side.func_176745_a()].translucentQuads;
        }
        return Collections.emptyList();
    }

    private BarrelBlockModelVariant getVariant(BarrelBlockModelKey key) {
        BarrelBlockModelVariant variant = this.cache.get(key);
        if (variant != null) {
            return variant;
        }
        variant = new BarrelBlockModelVariant();
        BarrelSkin skin = key.look.getSkin();
        IModel m = this.baseModels.get((Object)key.look.model).retexture(skin.skinMap.textures);
        IModel cm = this.cutoutModels.get((Object)key.look.model);
        for (int f = 0; f < 7; ++f) {
            int i;
            for (i = 0; i < variant.rotations.length; ++i) {
                variant.rotations[i][f] = new BarrelBlockModelVariant.Quads();
                List list = m.bake((IModelState)BarrelBlockModelKey.ROTATIONS[i], this.format, this.bakedTextureGetter).func_188616_a(null, f == 6 ? null : EnumFacing.field_82609_l[f], 0L);
                if (skin.layer == null || skin.layer == BlockRenderLayer.SOLID) {
                    variant.rotations[i][f].solidQuads.addAll(list);
                } else if (skin.layer == BlockRenderLayer.CUTOUT) {
                    variant.rotations[i][f].cutoutQuads.addAll(list);
                } else if (skin.layer == BlockRenderLayer.TRANSLUCENT) {
                    variant.rotations[i][f].translucentQuads.addAll(list);
                }
                if (cm == null) continue;
                variant.rotations[i][f].cutoutQuads.addAll(cm.bake((IModelState)BarrelBlockModelKey.ROTATIONS[i], this.format, this.bakedTextureGetter).func_188616_a(null, f == 6 ? null : EnumFacing.field_82609_l[f], 0L));
            }
            for (i = 0; i < variant.rotations.length; ++i) {
                variant.rotations[i][f].solidQuads = BakedBarrelBlockModel.optimize(variant.rotations[i][f].solidQuads);
                variant.rotations[i][f].cutoutQuads = BakedBarrelBlockModel.optimize(variant.rotations[i][f].cutoutQuads);
                variant.rotations[i][f].translucentQuads = BakedBarrelBlockModel.optimize(variant.rotations[i][f].translucentQuads);
            }
        }
        this.cache.put(key, variant);
        return variant;
    }

    private static List<BakedQuad> optimize(List<BakedQuad> l) {
        return l.isEmpty() ? Collections.emptyList() : (l.size() == 1 ? Collections.singletonList(l.get(0)) : Arrays.asList(l.toArray(new BakedQuad[0])));
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.itemOverrideList;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return BlockDecorativeBlock.particleLook.getSkin().skinMap.get(BlockDecorativeBlock.particleFacing, this.bakedTextureGetter);
    }
}

