/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.item;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.BlockTFLeaves3;
import twilightforest.block.TFBlocks;
import twilightforest.enums.Leaves3Variant;
import twilightforest.item.ItemTF;
import twilightforest.world.WorldProviderTwilightForest;

public class ItemTFMagicBeans
extends ItemTF {
    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        Block blockAt = world.func_180495_p(pos).func_177230_c();
        int minY = pos.func_177956_o() + 1;
        int maxY = Math.max(pos.func_177956_o() + 100, (int)(this.getCloudHeight(world) + 25.0f));
        if (pos.func_177956_o() < maxY && blockAt == TFBlocks.uberous_soil) {
            if (!world.field_72995_K) {
                ItemStack is = player.func_184586_b(hand);
                is.func_190918_g(1);
                this.makeHugeStalk(world, pos, minY, maxY);
                if (player instanceof EntityPlayerMP) {
                    TFAdvancements.ITEM_USE_TRIGGER.trigger((EntityPlayerMP)player, is, world, pos);
                }
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    private float getCloudHeight(World world) {
        if (world.field_73011_w instanceof WorldProviderTwilightForest) {
            return ((WorldProviderTwilightForest)world.field_73011_w).func_76571_f();
        }
        return 128.0f;
    }

    private void makeHugeStalk(World world, BlockPos pos, int minY, int maxY) {
        float x = pos.func_177958_n();
        float z = pos.func_177952_p();
        int yOffset = world.field_73012_v.nextInt(100);
        float cScale = world.field_73012_v.nextFloat() * 0.25f + 0.125f;
        float rScale = world.field_73012_v.nextFloat() * 0.25f + 0.125f;
        float radius = 4.0f + MathHelper.func_76126_a((float)((float)(minY + yOffset) * rScale)) * 3.0f;
        x -= MathHelper.func_76126_a((float)((float)(minY + yOffset) * cScale)) * radius;
        z -= MathHelper.func_76134_b((float)((float)(minY + yOffset) * cScale)) * radius;
        int nextLeafY = minY + 10 + world.field_73012_v.nextInt(20);
        boolean isClear = true;
        for (int dy = minY; dy < maxY && isClear; ++dy) {
            radius = 5.0f + MathHelper.func_76126_a((float)((float)(dy + yOffset) * rScale)) * 2.5f;
            float cx = x + MathHelper.func_76126_a((float)((float)(dy + yOffset) * cScale)) * radius;
            float cz = z + MathHelper.func_76134_b((float)((float)(dy + yOffset) * cScale)) * radius;
            float stalkThickness = 2.5f;
            if (maxY - dy < 5) {
                stalkThickness *= (float)(maxY - dy) / 5.0f;
            }
            int minX = MathHelper.func_76141_d((float)(x - radius - stalkThickness));
            int maxX = MathHelper.func_76123_f((float)(x + radius + stalkThickness));
            int minZ = MathHelper.func_76141_d((float)(z - radius - stalkThickness));
            int maxZ = MathHelper.func_76123_f((float)(z + radius + stalkThickness));
            for (int dx = minX; dx < maxX; ++dx) {
                for (int dz = minZ; dz < maxZ; ++dz) {
                    if (!(((float)dx - cx) * ((float)dx - cx) + ((float)dz - cz) * ((float)dz - cz) < stalkThickness * stalkThickness)) continue;
                    isClear &= this.tryToPlaceStalk(world, new BlockPos(dx, dy, dz));
                }
            }
            if (dy != nextLeafY) continue;
            int lx = (int)(x + MathHelper.func_76126_a((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            int lz = (int)(z + MathHelper.func_76134_b((float)((float)(dy + yOffset) * cScale)) * (radius + stalkThickness));
            this.placeLeaves(world, new BlockPos(lx, dy, lz));
            nextLeafY = dy + 5 + world.field_73012_v.nextInt(10);
        }
    }

    private void placeLeaves(World world, BlockPos pos) {
        int dz;
        int dx;
        world.func_175656_a(pos, TFBlocks.huge_stalk.func_176223_P());
        for (dx = -1; dx <= 1; ++dx) {
            for (dz = -1; dz <= 1; ++dz) {
                this.tryToPlaceLeaves(world, pos.func_177982_a(dx, -1, dz));
                this.tryToPlaceLeaves(world, pos.func_177982_a(dx, 1, dz));
            }
        }
        for (dx = -2; dx <= 2; ++dx) {
            for (dz = -2; dz <= 2; ++dz) {
                if ((dx == 2 || dx == -2) && (dz == 2 || dz == -2)) continue;
                this.tryToPlaceLeaves(world, pos.func_177982_a(dx, 0, dz));
            }
        }
    }

    private boolean tryToPlaceStalk(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().func_176200_f((IBlockAccess)world, pos) || state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos) || state.func_177230_c().canSustainLeaves(state, (IBlockAccess)world, pos)) {
            world.func_175656_a(pos, TFBlocks.huge_stalk.func_176223_P());
            return true;
        }
        return false;
    }

    private void tryToPlaceLeaves(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_177230_c().canBeReplacedByLeaves(state, (IBlockAccess)world, pos)) {
            world.func_180501_a(pos, TFBlocks.twilight_leaves_3.func_176223_P().func_177226_a(BlockTFLeaves3.VARIANT, (Comparable)((Object)Leaves3Variant.BEANSTALK)), 2);
        }
    }
}

