/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.network;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ListenerList;
import sonar.core.listener.PlayerListener;
import sonar.flux.FluxNetworks;
import sonar.flux.api.IFluxItemGui;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.common.events.FluxItemListenerEvent;
import sonar.flux.common.events.FluxTileListenerEvent;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.connection.FluxListener;
import sonar.flux.connection.FluxNetworkInvalid;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.PacketNetworkUpdate;

public class ListenerHelper {
    public static void onPlayerOpenItemGui(ItemStack stack, EntityPlayer player) {
        Preconditions.checkState((!player.func_130014_f_().field_72995_K ? 1 : 0) != 0);
        ListenerList<PlayerListener> listeners = FluxNetworkCache.instance().getOrCreateStackListeners(stack);
        int uuid = FluxNetworkCache.instance().getOrCreateUniqueID(stack);
        IFluxNetwork network = ListenerHelper.getViewingNetwork(stack);
        MinecraftForge.EVENT_BUS.post((Event)new FluxItemListenerEvent.AddConnectionListener(stack, uuid, network, listeners));
        if (!network.isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{network}), NBTHelper.SyncType.SAVE, true), (EntityPlayerMP)player);
        }
    }

    public static void onPlayerCloseItemGui(ItemStack stack, EntityPlayer player) {
        Preconditions.checkState((!player.func_130014_f_().field_72995_K ? 1 : 0) != 0);
        ListenerList<PlayerListener> listeners = FluxNetworkCache.instance().getOrCreateStackListeners(stack);
        int uuid = FluxNetworkCache.instance().getOrCreateUniqueID(stack);
        IFluxNetwork network = ListenerHelper.getViewingNetwork(stack);
        MinecraftForge.EVENT_BUS.post((Event)new FluxItemListenerEvent.RemoveConnectionListener(stack, uuid, network, listeners));
    }

    public static void onPlayerOpenItemTab(ItemStack stack, EntityPlayer player, EnumGuiTab tab) {
        Preconditions.checkState((!player.func_130014_f_().field_72995_K ? 1 : 0) != 0);
        ListenerList<PlayerListener> listeners = FluxNetworkCache.instance().getOrCreateStackListeners(stack);
        IFluxNetwork network = ListenerHelper.getViewingNetwork(stack);
        tab.getMonitoringTypes().forEach(m -> {
            listeners.addListener(player, new Enum[]{m});
            m.doOpenPacket(network, (EntityPlayerMP)player);
        });
    }

    public static void onPlayerCloseItemTab(ItemStack stack, EntityPlayer player, EnumGuiTab tab) {
        Preconditions.checkState((!player.func_130014_f_().field_72995_K ? 1 : 0) != 0);
        ListenerList<PlayerListener> listeners = FluxNetworkCache.instance().getOrCreateStackListeners(stack);
        IFluxNetwork network = ListenerHelper.getViewingNetwork(stack);
        tab.getMonitoringTypes().forEach(m -> {
            listeners.removeListener(player, true, new Enum[]{m});
            m.doClosePacket(network, (EntityPlayerMP)player);
        });
    }

    public static void onViewingNetworkChanged(ItemStack stack, IFluxNetwork old, IFluxNetwork network) {
        ListenerList<PlayerListener> listeners = FluxNetworkCache.instance().getOrCreateStackListeners(stack);
        int uuid = FluxNetworkCache.instance().getOrCreateUniqueID(stack);
        if (listeners.hasListeners()) {
            MinecraftForge.EVENT_BUS.post((Event)new FluxItemListenerEvent.RemoveConnectionListener(stack, uuid, old, listeners));
            MinecraftForge.EVENT_BUS.post((Event)new FluxItemListenerEvent.AddConnectionListener(stack, uuid, network, listeners));
            for (FluxListener l : FluxListener.values()) {
                listeners.getListeners(new Enum[]{l}).forEach(p -> l.doClosePacket(network, p.player));
                listeners.getListeners(new Enum[]{l}).forEach(p -> l.doOpenPacket(network, p.player));
            }
        }
    }

    public static IFluxNetwork getViewingNetwork(ItemStack stack) {
        if (stack.func_77973_b() instanceof IFluxItemGui) {
            int networkID = ((IFluxItemGui)stack.func_77973_b()).getViewingNetworkID(stack);
            return FluxNetworkCache.instance().getNetwork(networkID);
        }
        return FluxNetworkInvalid.INVALID;
    }

    public static void onPlayerOpenTileGui(TileFlux flux, EntityPlayer player) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        MinecraftForge.EVENT_BUS.post((Event)new FluxTileListenerEvent.AddConnectionListener(flux, flux.getNetwork()));
        if (!flux.getNetwork().isFakeNetwork()) {
            FluxNetworks.network.sendTo((IMessage)new PacketNetworkUpdate(Lists.newArrayList((Object[])new IFluxNetwork[]{flux.getNetwork()}), NBTHelper.SyncType.SAVE, true), (EntityPlayerMP)player);
        }
    }

    public static void onPlayerCloseTileGui(TileFlux flux, EntityPlayer player) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        MinecraftForge.EVENT_BUS.post((Event)new FluxTileListenerEvent.RemoveConnectionListener(flux, flux.getNetwork()));
    }

    public static void onPlayerOpenTileTab(TileFlux flux, EntityPlayer player, EnumGuiTab tab) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        tab.getMonitoringTypes().forEach(m -> {
            flux.listeners.addListener(player, new Enum[]{m});
            m.doOpenPacket(flux.getNetwork(), (EntityPlayerMP)player);
        });
    }

    public static void onPlayerCloseTileTab(TileFlux flux, EntityPlayer player, EnumGuiTab tab) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        tab.getMonitoringTypes().forEach(m -> {
            flux.listeners.removeListener(player, true, new Enum[]{m});
            m.doClosePacket(flux.getNetwork(), (EntityPlayerMP)player);
        });
    }

    public static void onNetworkChanged(TileFlux flux, IFluxNetwork old, IFluxNetwork network) {
        Preconditions.checkState((!flux.func_145831_w().field_72995_K ? 1 : 0) != 0);
        if (network.isFakeNetwork()) {
            FluxNetworkCache.instance().onTileDisconnected(flux);
        } else {
            FluxNetworkCache.instance().onTileConnected(flux);
        }
        if (flux.getListenerList().hasListeners()) {
            MinecraftForge.EVENT_BUS.post((Event)new FluxTileListenerEvent.RemoveConnectionListener(flux, old));
            MinecraftForge.EVENT_BUS.post((Event)new FluxTileListenerEvent.AddConnectionListener(flux, network));
            for (FluxListener l : FluxListener.values()) {
                flux.listeners.getListeners(new Enum[]{l}).forEach(p -> l.doClosePacket(network, p.player));
                flux.listeners.getListeners(new Enum[]{l}).forEach(p -> l.doOpenPacket(network, p.player));
            }
        }
    }
}

