/*
 * Decompiled with CFR 0.152.
 */
package sonar.flux.common.item;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import sonar.core.SonarCore;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.SonarHelper;
import sonar.flux.FluxTranslate;
import sonar.flux.api.configurator.FluxConfigurationType;
import sonar.flux.api.configurator.IFluxConfigurable;
import sonar.flux.api.network.IFluxNetwork;
import sonar.flux.client.FluxColourHandler;
import sonar.flux.client.gui.EnumGuiTab;
import sonar.flux.client.gui.tabs.GuiTabIndexConfigurator;
import sonar.flux.common.item.ItemAbstractGui;
import sonar.flux.common.tileentity.TileFlux;
import sonar.flux.network.FluxNetworkCache;
import sonar.flux.network.ListenerHelper;

public class ItemConfigurator
extends ItemAbstractGui {
    public static final String CONFIGS_TAG = "configs";
    public static final String DISABLED_TAG = "disabled";

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof IFluxConfigurable)) {
            SonarCore.instance.guiHandler.openBasicItemStack(false, player.func_184586_b(hand), player, world, player.func_180425_c(), 0);
            return EnumActionResult.SUCCESS;
        }
        IFluxConfigurable configurable = (IFluxConfigurable)tile;
        if (!configurable.canAccess(player).canEdit()) {
            FontHelper.sendMessage((String)(SonarHelper.getProfileByUUID((UUID)configurable.getConnectionOwner()).getName() + " : You don't have permission to access this network"), (World)world, (EntityPlayer)player);
            return EnumActionResult.FAIL;
        }
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            NBTTagCompound disabled = stack.func_190925_c(DISABLED_TAG);
            stack.func_77983_a(CONFIGS_TAG, (NBTBase)configurable.copyConfiguration(new NBTTagCompound(), disabled, player));
            FontHelper.sendMessage((String)"Copied Configuration", (World)world, (EntityPlayer)player);
        } else {
            NBTTagCompound configs = stack.func_190925_c(CONFIGS_TAG);
            if (!configs.func_82582_d()) {
                NBTTagCompound disabled = stack.func_190925_c(DISABLED_TAG);
                configurable.pasteConfiguration(configs, disabled, player);
                FontHelper.sendMessage((String)"Pasted Configuration", (World)world, (EntityPlayer)player);
            } else {
                FontHelper.sendMessage((String)"NO CONFIGURATION TO PASTE", (World)world, (EntityPlayer)player);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public static NBTTagCompound copyConfiguration(TileFlux flux, NBTTagCompound config, NBTTagCompound disabled, EntityPlayer player) {
        for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
            type.copy.copyFromTile(config, type.getNBTName(), flux);
        }
        return config;
    }

    public static void pasteConfiguration(TileFlux flux, NBTTagCompound config, NBTTagCompound disabled, EntityPlayer player) {
        for (FluxConfigurationType type : FluxConfigurationType.VALUES) {
            if (!config.func_74764_b(type.getNBTName()) || disabled.func_74767_n(type.getNBTName())) continue;
            type.paste.pasteToTile(config, type.getNBTName(), flux);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(@Nonnull ItemStack stack, World world, @Nonnull List<String> list, @Nonnull ITooltipFlag flag) {
        NBTTagCompound tag = stack.func_179543_a(CONFIGS_TAG);
        if (tag != null) {
            list.add(FluxTranslate.NETWORK_NAME.t() + ": " + FluxColourHandler.getOrRequestNetworkName(tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName())));
        } else {
            super.func_77624_a(stack, world, list, flag);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K) {
            SonarCore.instance.guiHandler.openBasicItemStack(false, stack, player, world, player.func_180425_c(), 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public int getViewingNetworkID(ItemStack stack) {
        NBTTagCompound tag = stack.func_179543_a(CONFIGS_TAG);
        if (tag == null || !tag.func_74764_b(FluxConfigurationType.NETWORK.getNBTName())) {
            return -1;
        }
        return tag.func_74762_e(FluxConfigurationType.NETWORK.getNBTName());
    }

    @Override
    public void setViewingNetworkID(ItemStack stack, int networkID) {
        int oldID = this.getViewingNetworkID(stack);
        stack.func_190925_c(CONFIGS_TAG).func_74768_a(FluxConfigurationType.NETWORK.getNBTName(), networkID);
        IFluxNetwork old = FluxNetworkCache.instance().getNetwork(oldID);
        IFluxNetwork network = FluxNetworkCache.instance().getNetwork(networkID);
        ListenerHelper.onViewingNetworkChanged(stack, old, network);
    }

    @Override
    @Nonnull
    public Object getIndexScreen(ItemStack stack, List<EnumGuiTab> tabs) {
        return new GuiTabIndexConfigurator(tabs);
    }
}

