/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.util.DankNullUtils;
import p455w0rdslib.util.EasyMappings;

public class PacketSyncDankNullDock
implements IMessage {
    private BlockPos dockPos;
    private ItemStack dankNull;
    private int[] stackSizes;

    public void fromBytes(ByteBuf buf) {
        this.dockPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.dankNull = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.stackSizes = new int[buf.readInt()];
        for (int i = 0; i < this.stackSizes.length - 1; ++i) {
            this.stackSizes[i] = buf.readInt();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.dockPos.func_177958_n());
        buf.writeInt(this.dockPos.func_177956_o());
        buf.writeInt(this.dockPos.func_177952_p());
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.dankNull);
        InventoryDankNull inv = DankNullUtils.getNewDankNullInventory(this.dankNull);
        buf.writeInt(inv.func_70302_i_());
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            buf.writeInt(inv.getSizeForSlot(i));
        }
    }

    public PacketSyncDankNullDock() {
    }

    public PacketSyncDankNullDock(@Nonnull TileDankNullDock dockingStation, ItemStack dankNull) {
        this.dockPos = dockingStation.func_174877_v();
        this.dankNull = dankNull;
    }

    public static class Handler
    implements IMessageHandler<PacketSyncDankNullDock, IMessage> {
        public IMessage onMessage(PacketSyncDankNullDock message, MessageContext ctx) {
            FMLCommonHandler.instance().getWorldThread(ctx.netHandler).func_152344_a(() -> this.handle(message, (EntityPlayer)(ctx.side == Side.SERVER ? ctx.getServerHandler().field_147369_b : EasyMappings.player()), ctx.side));
            return null;
        }

        private void handle(PacketSyncDankNullDock message, EntityPlayer player, Side side) {
            World world = player.func_130014_f_();
            if (world != null && world.func_175625_s(message.dockPos) != null && world.func_175625_s(message.dockPos) instanceof TileDankNullDock) {
                TileDankNullDock dankDock = (TileDankNullDock)world.func_175625_s(message.dockPos);
                ItemStack dankNull = message.dankNull;
                dankDock.setDankNull(dankNull);
                dankDock.func_70296_d();
                IBlockState s = world.func_180495_p(dankDock.func_174877_v());
                world.func_184138_a(dankDock.func_174877_v(), s, s, 3);
            }
        }
    }
}

