/*
 * Decompiled with CFR 0.152.
 */
package p455w0rd.danknull.container;

import java.util.Objects;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import p455w0rd.danknull.blocks.tiles.TileDankNullDock;
import p455w0rd.danknull.init.ModNetworking;
import p455w0rd.danknull.inventory.InventoryDankNull;
import p455w0rd.danknull.inventory.slot.SlotDankNullDock;
import p455w0rd.danknull.inventory.slot.SlotHotbar;
import p455w0rd.danknull.network.PacketChangeMode;
import p455w0rd.danknull.network.PacketSyncDankNullDock;
import p455w0rd.danknull.network.PacketUpdateSlot;
import p455w0rd.danknull.util.DankNullUtils;

public class ContainerDankNullDock
extends Container {
    private final TileDankNullDock tile;

    public ContainerDankNullDock(EntityPlayer player, TileDankNullDock tile) {
        int i;
        this.tile = tile;
        InventoryPlayer playerInv = player.field_71071_by;
        ItemStack dankNull = tile.getDankNull();
        int lockedSlot = -1;
        int numRows = DankNullUtils.getMeta(dankNull) + 1;
        if (DankNullUtils.isCreativeDankNull(dankNull)) {
            --numRows;
        }
        for (i = 0; i < playerInv.func_70302_i_(); ++i) {
            ItemStack currStack = playerInv.func_70301_a(i);
            if (currStack.func_190926_b() || currStack != dankNull) continue;
            lockedSlot = i;
        }
        for (i = 0; i < 9; ++i) {
            this.func_75146_a(new SlotHotbar((IInventory)playerInv, i, i * 20 + 9 + i, 90 + numRows - 1 + numRows * 20 + 6, lockedSlot == i));
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new Slot((IInventory)playerInv, j + i * 9 + 9, j * 20 + 9 + j, 149 + numRows - 1 + i - (6 - numRows) * 20 + i * 20));
            }
        }
        for (i = 0; i < numRows; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.func_75146_a(new SlotDankNullDock(this, j + i * 9, j * 20 + 9 + j, 19 + i + i * 20));
            }
        }
        if (tile.func_145831_w() != null) {
            tile.func_70296_d();
            IBlockState s = tile.func_145831_w().func_180495_p(tile.func_174877_v());
            tile.func_145831_w().func_184138_a(tile.func_174877_v(), s, s, 3);
        }
    }

    public TileDankNullDock getTile() {
        return this.tile;
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return DankNullUtils.getNewDankNullInventory(this.getDankNull()).isValid();
    }

    public ItemStack getDankNull() {
        return this.getTile().getDankNull();
    }

    private ItemStack addStack(InventoryDankNull inventory, ItemStack stack) {
        ItemStack leftover = ItemStack.field_190927_a;
        if (DankNullUtils.isDankNull(stack)) {
            return stack;
        }
        if (DankNullUtils.isFiltered(inventory, stack)) {
            leftover = DankNullUtils.addFilteredStackToDankNull(inventory, stack);
        } else if (DankNullUtils.getNextAvailableSlot(inventory) >= 0) {
            int nextSlot = DankNullUtils.getNextAvailableSlot(inventory);
            inventory.func_70299_a(nextSlot, stack);
            ((Slot)this.field_75151_b.get(36 + nextSlot)).func_75215_d(stack);
        }
        if (DankNullUtils.getSelectedStackIndex(inventory) == -1) {
            DankNullUtils.setSelectedIndexApplicable(inventory);
        }
        DankNullUtils.reArrangeStacks(inventory);
        return leftover;
    }

    private boolean isDankNullSlot(Slot slot) {
        return slot instanceof SlotDankNullDock;
    }

    private boolean isInHotbar(int index) {
        return index >= 0 && index <= 8;
    }

    private boolean isInInventory(int index) {
        return index >= 9 && index <= 36;
    }

    public void func_75142_b() {
        for (int i = 0; i < this.field_75151_b.size(); ++i) {
            ItemStack slotStack = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack clientStack = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)clientStack, (ItemStack)slotStack) || ItemStack.areItemStacksEqualUsingNBTShareTag((ItemStack)clientStack, (ItemStack)slotStack)) continue;
            clientStack = slotStack.func_190926_b() ? ItemStack.field_190927_a : slotStack.func_77946_l();
            this.field_75153_a.set(i, (Object)clientStack);
            for (IContainerListener listener : this.field_75149_d) {
                if (!(listener instanceof EntityPlayerMP)) continue;
                ModNetworking.getInstance().sendTo((IMessage)new PacketUpdateSlot(i, clientStack), (EntityPlayerMP)listener);
            }
        }
    }

    public Slot func_75139_a(int slotId) {
        if (slotId < this.field_75151_b.size() && slotId >= 0) {
            return (Slot)this.field_75151_b.get(slotId);
        }
        return null;
    }

    public ItemStack func_184996_a(int index, int dragType, ClickType clickType, EntityPlayer player) {
        Slot s = this.func_75139_a(index);
        if (s == null || index < 36 && clickType != ClickType.QUICK_MOVE || clickType == ClickType.CLONE) {
            return super.func_184996_a(index, dragType, clickType, player);
        }
        InventoryDankNull tmpInv = DankNullUtils.getNewDankNullInventory(this.getDankNull());
        Objects.requireNonNull(tmpInv, "Failed to create InventoryDankNull");
        if (clickType == ClickType.QUICK_MOVE) {
            return this.shiftClick(tmpInv, index, player);
        }
        InventoryPlayer inventoryplayer = player.field_71071_by;
        ItemStack heldStack = inventoryplayer.func_70445_o();
        if (s instanceof SlotDankNullDock && clickType == ClickType.PICKUP) {
            if (DankNullUtils.isDankNull(heldStack)) {
                return ItemStack.field_190927_a;
            }
            ItemStack thisStack = s.func_75211_c();
            if (!thisStack.func_190926_b() && DankNullUtils.isDankNull(thisStack)) {
                return ItemStack.field_190927_a;
            }
            if (!heldStack.func_190926_b()) {
                if (!DankNullUtils.canStackBeAdded(tmpInv, heldStack)) {
                    return ItemStack.field_190927_a;
                }
                ItemStack toAdd = heldStack.func_77946_l();
                if (dragType == 1) {
                    toAdd.func_190920_e(1);
                }
                ItemStack leftover = this.addStack(tmpInv, toAdd);
                if (dragType == 0) {
                    if (!leftover.func_190926_b()) {
                        inventoryplayer.func_70437_b(leftover);
                    } else {
                        inventoryplayer.func_70437_b(ItemStack.field_190927_a);
                    }
                } else if (dragType == 1 && leftover.func_190926_b()) {
                    heldStack.func_190918_g(1);
                    inventoryplayer.func_70437_b(heldStack);
                }
                tmpInv.func_70296_d();
                inventoryplayer.func_70296_d();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                    this.sync(tmpInv.getDankNull(), player);
                }
            } else if (!thisStack.func_190926_b()) {
                int max = thisStack.func_77976_d();
                ItemStack newStack = thisStack.func_77946_l();
                if (thisStack.func_190916_E() >= max) {
                    newStack.func_190920_e(max);
                }
                if (dragType == 1) {
                    int returnSize = Math.min(newStack.func_190916_E() / 2, newStack.func_190916_E());
                    DankNullUtils.decrDankNullStackSize(tmpInv, thisStack, returnSize);
                    newStack.func_190920_e(returnSize + (newStack.func_190916_E() % 2 == 0 ? 0 : 1));
                } else if (dragType == 0) {
                    DankNullUtils.decrDankNullStackSize(tmpInv, thisStack, newStack.func_190916_E());
                    if (((Slot)this.field_75151_b.get(index)).func_75216_d() && ((Slot)this.field_75151_b.get(index)).func_75211_c().func_190916_E() <= 0) {
                        ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
                    }
                }
                inventoryplayer.func_70437_b(newStack);
                inventoryplayer.func_70296_d();
                DankNullUtils.reArrangeStacks(tmpInv);
                tmpInv.func_70296_d();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                    this.sync(tmpInv.getDankNull(), player);
                }
            }
        }
        return ItemStack.field_190927_a;
    }

    private void sync(ItemStack dankNull, EntityPlayer player) {
        if (!(player instanceof EntityPlayerMP)) {
            throw new RuntimeException("Only call on server!");
        }
        ModNetworking.getInstance().sendTo((IMessage)new PacketSyncDankNullDock(this.getTile(), dankNull), (EntityPlayerMP)player);
    }

    private ItemStack shiftClick(InventoryDankNull inventory, int index, EntityPlayer player) {
        Slot clickSlot = (Slot)this.field_75151_b.get(index);
        if (clickSlot.func_75216_d()) {
            if (!this.isDankNullSlot(clickSlot)) {
                ItemStack leftover = this.addStack(inventory, clickSlot.func_75211_c());
                clickSlot.func_75215_d(leftover);
                DankNullUtils.setSelectedIndexApplicable(inventory);
                inventory.func_70296_d();
                player.field_71071_by.func_70296_d();
                if (player instanceof EntityPlayerMP) {
                    this.sync(inventory.getDankNull(), player);
                }
                return ItemStack.field_190927_a;
            }
            ItemStack newStack = clickSlot.func_75211_c().func_77946_l();
            int realMaxStackSize = newStack.func_77976_d();
            int currentStackSize = newStack.func_190916_E();
            if (!DankNullUtils.isCreativeDankNull(this.getDankNull())) {
                if (currentStackSize > realMaxStackSize) {
                    newStack.func_190920_e(realMaxStackSize);
                }
                if (this.moveStackToInventory(newStack)) {
                    DankNullUtils.decrDankNullStackSize(inventory, clickSlot.func_75211_c(), realMaxStackSize);
                }
                if (player instanceof EntityPlayerMP) {
                    this.sync(inventory.getDankNull(), player);
                }
            } else {
                newStack.func_190920_e(DankNullUtils.isCreativeDankNull(this.getDankNull()) ? newStack.func_77976_d() : currentStackSize);
                if (this.moveStackToInventory(newStack) && !(player instanceof EntityPlayerMP)) {
                    DankNullUtils.decrDankNullStackSize(inventory, clickSlot.func_75211_c(), currentStackSize);
                    if (DankNullUtils.isCreativeDankNull(this.getDankNull()) && !DankNullUtils.isCreativeDankNullLocked(this.getDankNull())) {
                        clickSlot.func_75215_d(ItemStack.field_190927_a);
                    }
                }
                if (!(player instanceof EntityPlayerMP)) {
                    this.sync(this.getDankNull(), player);
                }
                if (player instanceof EntityPlayerMP) {
                    player.field_71071_by.func_70299_a(index, newStack);
                    player.field_71071_by.func_70296_d();
                }
                DankNullUtils.reArrangeStacks(inventory);
            }
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }

    private boolean moveStackWithinInventory(ItemStack itemStackIn, int index) {
        block5: {
            block4: {
                if (!this.isInHotbar(index)) break block4;
                if (this.func_75135_a(itemStackIn, 9, 37, false)) {
                    return true;
                }
                for (int i = 9; i <= 36; ++i) {
                    Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
                    if (possiblyOpenSlot.func_75216_d()) continue;
                    possiblyOpenSlot.func_75215_d(itemStackIn);
                    ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
                    return true;
                }
                break block5;
            }
            if (!this.isInInventory(index)) break block5;
            if (this.func_75135_a(itemStackIn, 0, 9, false)) {
                return true;
            }
            for (int i = 0; i <= 8; ++i) {
                Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
                if (possiblyOpenSlot.func_75216_d()) continue;
                possiblyOpenSlot.func_75215_d(itemStackIn);
                ((Slot)this.field_75151_b.get(index)).func_75215_d(ItemStack.field_190927_a);
                return true;
            }
        }
        return false;
    }

    private boolean moveStackToInventory(ItemStack itemStackIn) {
        for (int i = 0; i < 36; ++i) {
            Slot possiblyOpenSlot = (Slot)this.field_75151_b.get(i);
            if (possiblyOpenSlot.func_75216_d()) continue;
            possiblyOpenSlot.func_75215_d(itemStackIn);
            return true;
        }
        return false;
    }

    public void handleModeUpdate(PacketChangeMode.ChangeType changeType, int slot) {
        ItemStack dankNull = this.getDankNull();
        ItemStack slotStack = slot >= 0 ? DankNullUtils.getItemByIndex(DankNullUtils.getNewDankNullInventory(dankNull), slot) : ItemStack.field_190927_a;
        switch (changeType) {
            case SELECTED: {
                DankNullUtils.setSelectedStackIndex(dankNull, slot);
                break;
            }
            case LOCK: {
                DankNullUtils.setLocked(dankNull, true);
                break;
            }
            case UNLOCK: {
                DankNullUtils.setLocked(dankNull, false);
                break;
            }
            case ORE_ON: {
                DankNullUtils.setOreDictModeForStack(dankNull, slotStack, true);
                break;
            }
            case ORE_OFF: {
                DankNullUtils.setOreDictModeForStack(dankNull, slotStack, false);
                break;
            }
            case EXTRACT_KEEP_ALL: {
                DankNullUtils.setExtractionModeForStack(dankNull, slotStack, DankNullUtils.ItemExtractionMode.KEEP_ALL);
                break;
            }
            case EXTRACT_KEEP_1: {
                DankNullUtils.setExtractionModeForStack(dankNull, slotStack, DankNullUtils.ItemExtractionMode.KEEP_1);
                break;
            }
            case EXTRACT_KEEP_16: {
                DankNullUtils.setExtractionModeForStack(dankNull, slotStack, DankNullUtils.ItemExtractionMode.KEEP_16);
                break;
            }
            case EXTRACT_KEEP_64: {
                DankNullUtils.setExtractionModeForStack(dankNull, slotStack, DankNullUtils.ItemExtractionMode.KEEP_64);
                break;
            }
            case EXTRACT_KEEP_NONE: {
                DankNullUtils.setExtractionModeForStack(dankNull, slotStack, DankNullUtils.ItemExtractionMode.KEEP_NONE);
                break;
            }
            case PLACE_KEEP_ALL: {
                DankNullUtils.setPlacementModeForStack(dankNull, slotStack, DankNullUtils.ItemPlacementMode.KEEP_ALL);
                break;
            }
            case PLACE_KEEP_1: {
                DankNullUtils.setPlacementModeForStack(dankNull, slotStack, DankNullUtils.ItemPlacementMode.KEEP_1);
                break;
            }
            case PLACE_KEEP_16: {
                DankNullUtils.setPlacementModeForStack(dankNull, slotStack, DankNullUtils.ItemPlacementMode.KEEP_16);
                break;
            }
            case PLACE_KEEP_64: {
                DankNullUtils.setPlacementModeForStack(dankNull, slotStack, DankNullUtils.ItemPlacementMode.KEEP_64);
                break;
            }
            case PLACE_KEEP_NONE: {
                DankNullUtils.setPlacementModeForStack(dankNull, slotStack, DankNullUtils.ItemPlacementMode.KEEP_NONE);
            }
        }
    }
}

