/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.common.table;

import com.google.common.base.Predicate;
import engineers.workshop.EngineersWorkshop;
import engineers.workshop.client.container.slot.SlotBase;
import engineers.workshop.common.table.TileTable;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockTable
extends Block
implements ITileEntityProvider {
    public static final PropertyDirection FACING = PropertyDirection.func_177712_a((String)"facing", (Predicate)EnumFacing.Plane.HORIZONTAL);

    public BlockTable() {
        super(Material.field_151576_e);
        this.func_149711_c(3.5f);
        this.func_149647_a(EngineersWorkshop.tabWorkshop);
        this.setRegistryName("engineersworkshop:blockTable");
        this.func_149663_c("engineersworkshop:blockTable");
        GameData.register_impl((IForgeRegistryEntry)this);
        ItemBlock itemBlock = new ItemBlock((Block)this);
        itemBlock.setRegistryName(this.getRegistryName());
        GameData.register_impl((IForgeRegistryEntry)itemBlock);
        GameRegistry.registerTileEntity(TileTable.class, (String)"engineersworkshop:blockTable");
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()), 2);
    }

    public IBlockState func_176203_a(int meta) {
        if (meta >= EnumFacing.field_176754_o.length) {
            meta = 0;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileTable();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)playerIn, (Object)EngineersWorkshop.instance, (int)0, (World)worldIn, (int)pos.func_177958_n(), (int)pos.func_177956_o(), (int)pos.func_177952_p());
        }
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!world.field_72995_K) {
            if (!player.func_184812_l_()) {
                this.dropInventory(world, pos);
            }
            world.func_175655_b(pos, !player.func_184812_l_());
        }
        return false;
    }

    protected void dropInventory(World world, BlockPos pos) {
        if (!world.field_72995_K) {
            int x = pos.func_177958_n();
            int y = pos.func_177956_o();
            int z = pos.func_177952_p();
            TileEntity tileEntity = world.func_175625_s(pos);
            if (tileEntity instanceof TileTable) {
                TileTable table = (TileTable)tileEntity;
                for (SlotBase slot : table.getSlots()) {
                    ItemStack itemStack;
                    if (!slot.shouldDropOnClosing() || (itemStack = slot.func_75211_c()).func_190926_b()) continue;
                    Random random = new Random();
                    float dX = random.nextFloat() * 0.8f + 0.1f;
                    float dY = random.nextFloat() * 0.8f + 0.1f;
                    float dZ = random.nextFloat() * 0.8f + 0.1f;
                    EntityItem entityItem = new EntityItem(world, (double)((float)x + dX), (double)((float)y + dY), (double)((float)z + dZ), itemStack.func_77946_l());
                    if (itemStack.func_77942_o()) {
                        entityItem.func_92059_d().func_77982_d(itemStack.func_77978_p().func_74737_b());
                    }
                    float factor = 0.05f;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor + 0.2;
                    entityItem.field_70159_w = random.nextGaussian() * (double)factor;
                    world.func_72838_d((Entity)entityItem);
                    itemStack.func_190920_e(0);
                }
            }
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        super.func_180663_b(worldIn, pos, state);
        worldIn.func_175713_t(pos);
    }
}

