/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.container.slot.SlotUpgrade;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.items.ItemUpgrade;
import engineers.workshop.common.items.Upgrade;
import engineers.workshop.common.table.TileTable;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;

public class PageUpgrades
extends Page {
    private static final int START_X = 10;
    private static final int START_Y = 20;
    private static final int OFFSET_X = 100;
    private static final int OFFSET_Y = 50;
    private static final int SLOT_SIZE = 18;
    private static final int SLOTS_PER_ROW = 4;
    private static final int SLOT_ROWS = 2;
    private static final int GLOBAL_SLOTS = 8;
    private static final int GLOBAL_X = 10;
    private static final int GLOBAL_Y = 130;
    private static final int GLOBAL_ID = 4;
    private int startId;
    private Map[] upgrades;

    public PageUpgrades(TileTable table, String name) {
        super(table, name);
    }

    @Override
    public int createSlots(int id) {
        this.startId = id;
        for (int y = 0; y < 2; ++y) {
            for (int x = 0; x < 2; ++x) {
                SlotUpgrade main = null;
                for (int r = 0; r < 2; ++r) {
                    for (int c = 0; c < 4; ++c) {
                        SlotUpgrade slot = new SlotUpgrade(this.table, this, id++, 10 + 100 * x + 18 * c, 20 + 50 * y + 18 * r, main, x + y * 2);
                        this.addSlot(slot);
                        if (main != null) continue;
                        main = slot;
                    }
                }
            }
        }
        for (int i = 0; i < 8; ++i) {
            this.addSlot(new SlotUpgrade(this.table, this, id++, 10 + 18 * i, 130, null, 4));
        }
        return id;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        super.draw(gui, mX, mY);
        gui.drawString("GLOBAL UPGRADES", 10, 120, 0x1E1E1E);
    }

    public ItemStack getUpgradeMainItem(int id) {
        return this.table.getSlots().get(this.startId + id * 2 * 4).func_75211_c();
    }

    public void onUpgradeChange() {
        this.upgrades = new Map[5];
        for (int i = 0; i < 4; ++i) {
            if (this.getUpgradeMainItem(i) == null) continue;
            this.upgrades[i] = this.loadUpgrades(this.startId + i * 2 * 4 + 1, 7);
        }
        this.upgrades[4] = this.loadUpgrades(this.startId + 32, 8);
    }

    public int getUpgradeCountRaw(int id, Upgrade upgrade) {
        Integer count;
        Map map = this.upgrades[id];
        if (map != null && (count = (Integer)map.get((Object)upgrade)) != null) {
            return count;
        }
        return 0;
    }

    public int getUpgradeCount(int id, Upgrade upgrade) {
        return Math.min(this.getUpgradeCountRaw(id, upgrade), upgrade.getMaxCount());
    }

    public boolean hasUpgrade(int id, Upgrade upgrade) {
        return this.getUpgradeCount(id, upgrade) > 0;
    }

    public int getGlobalUpgradeCount(Upgrade upgrade) {
        return this.getUpgradeCount(4, upgrade);
    }

    public boolean hasGlobalUpgrade(Upgrade upgrade) {
        return this.hasUpgrade(4, upgrade);
    }

    private Map<Upgrade, Integer> loadUpgrades(int startId, int length) {
        HashMap<Upgrade, Integer> map = new HashMap<Upgrade, Integer>();
        for (int i = startId; i < startId + length; ++i) {
            ItemStack itemStack = this.table.func_70301_a(i);
            Upgrade upgrade = ItemUpgrade.getUpgrade(itemStack);
            if (upgrade == null) continue;
            Integer count = (Integer)map.get((Object)upgrade);
            if (count == null) {
                count = 0;
            }
            count = count + itemStack.func_190916_E();
            map.put(upgrade, count);
        }
        return map;
    }

    @Override
    public String getDesc() {
        return "Manage Upgrades";
    }
}

