/*
 * Decompiled with CFR 0.152.
 */
package engineers.workshop.client.page;

import engineers.workshop.client.GuiBase;
import engineers.workshop.client.page.Page;
import engineers.workshop.common.table.TileTable;
import engineers.workshop.common.unit.Unit;
import engineers.workshop.common.unit.UnitCraft;
import engineers.workshop.common.unit.UnitSmelt;
import engineers.workshop.common.unit.UnitStorage;
import java.util.ArrayList;
import java.util.List;

public class PageMain
extends Page {
    public static final int WIDTH = 256;
    public static final int HEIGHT = 174;
    private static final int TEXTURE_SHEET_SIZE = 256;
    private static final int BAR_THICKNESS = 4;
    private static final int BAR_WIDTH = 240;
    private static final int BAR_HEIGHT = 162;
    private static final int BAR_HORIZONTAL_X = 8;
    private static final int BAR_HORIZONTAL_Y = 85;
    private static final int BAR_VERTICAL_X = 126;
    private static final int BAR_VERTICAL_Y = 6;
    private List<Unit> units = new ArrayList<Unit>();
    private List<UnitCraft> craftingList = new ArrayList<UnitCraft>();
    private List<UnitSmelt> smeltingList = new ArrayList<UnitSmelt>();
    private List<UnitStorage> storageList = new ArrayList<UnitStorage>();

    public PageMain(TileTable table, String name) {
        super(table, name);
        for (int i = 0; i < 4; ++i) {
            this.addUnit(i);
        }
    }

    private void addUnit(int id) {
        int x = id % 2 * 256 / 2;
        int y = id / 2 * 174 / 2;
        UnitCraft crafting = new UnitCraft(this.table, this, id, x, y);
        this.craftingList.add(crafting);
        this.units.add(crafting);
        UnitSmelt smelting = new UnitSmelt(this.table, this, id, x, y);
        this.smeltingList.add(smelting);
        this.units.add(smelting);
        UnitStorage storage = new UnitStorage(this.table, this, id, x, y);
        this.storageList.add(storage);
        this.units.add(storage);
    }

    public List<UnitSmelt> getSmeltingList() {
        return this.smeltingList;
    }

    public List<UnitCraft> getCraftingList() {
        return this.craftingList;
    }

    public List<UnitStorage> getStorageList() {
        return this.storageList;
    }

    @Override
    public void onUpdate() {
        for (Unit unit : this.units) {
            if (!unit.isEnabled()) continue;
            unit.onUpdate();
        }
    }

    @Override
    public int createSlots(int id) {
        for (Unit unit : this.units) {
            id = unit.createSlots(id);
        }
        return id;
    }

    @Override
    public void draw(GuiBase gui, int mX, int mY) {
        gui.prepare();
        int enabledUnits = 0;
        for (Unit unit2 : this.units) {
            if (!unit2.isEnabled()) continue;
            ++enabledUnits;
        }
        if (this.drawHorizontal()) {
            gui.drawRect(8, 85, 0, 252, 240, 4);
        }
        if (this.drawVertical()) {
            gui.drawRect(126, 6, 252, 0, 4, 162);
        }
        if (enabledUnits == 0) {
            gui.drawString("ADD A CRAFTING TABLE, CHEST OR FURNACE", 45, 30, 0x1E1E1E);
            gui.drawString("IN THE UPGRADE PAGE TO GET STARTED", 40, 45, 0x1E1E1E);
        }
        this.units.stream().filter(Unit::isEnabled).forEachOrdered(unit -> unit.draw(gui, mX, mY));
    }

    @Override
    public void onClick(GuiBase gui, int mX, int mY, int button) {
        this.units.stream().filter(Unit::isEnabled).forEachOrdered(unit -> unit.onClick(gui, mX, mY));
    }

    public List<Unit> getUnits() {
        return this.units;
    }

    @Override
    public String getDesc() {
        return "Workshop Area";
    }

    private boolean[] makeUnitMap() {
        boolean[] out = new boolean[4];
        for (int i = 0; i < out.length; ++i) {
            out[i] = this.isUnitLoaded(i);
        }
        return out;
    }

    private boolean isUnitLoaded(int id) {
        if (this.craftingList.size() <= id || this.smeltingList.size() <= id || this.storageList.size() <= id) {
            return false;
        }
        return this.craftingList.get(id) != null && this.craftingList.get(id).isEnabled() || this.smeltingList.get(id) != null && this.smeltingList.get(id).isEnabled() || this.storageList.get(id) != null && this.storageList.get(id).isEnabled();
    }

    public boolean drawVertical() {
        boolean[] map = this.makeUnitMap();
        return map[0] && map[1] || map[0] && map[3] || map[2] && map[1] || map[2] && map[3];
    }

    public boolean drawHorizontal() {
        boolean[] map = this.makeUnitMap();
        return map[0] && map[2] || map[0] && map[3] || map[1] && map[2] || map[1] && map[3];
    }
}

