/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.registry;

import buildcraft.lib.block.BlockBCBase_Neptune;
import buildcraft.lib.item.IItemBuildCraft;
import buildcraft.lib.item.ItemBlockBC_Neptune;
import buildcraft.lib.registry.MigrationManager;
import buildcraft.lib.registry.RegistryConfig;
import buildcraft.lib.registry.TagManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class RegistrationHelper {
    private static final Map<String, Block> oredictBlocks = new HashMap<String, Block>();
    private static final Map<String, Item> oredictItems = new HashMap<String, Item>();
    private final List<Block> blocks = new ArrayList<Block>();
    private final List<Item> items = new ArrayList<Item>();

    public RegistrationHelper() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void registerOredictEntries() {
        for (Map.Entry<String, Item> entry : oredictItems.entrySet()) {
            OreDictionary.registerOre((String)entry.getKey(), (Item)entry.getValue());
        }
        for (Map.Entry<String, Item> entry : oredictBlocks.entrySet()) {
            OreDictionary.registerOre((String)entry.getKey(), (Block)((Block)entry.getValue()));
        }
    }

    @SubscribeEvent
    public final void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : this.blocks) {
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public final void onRegisterItems(RegistryEvent.Register<Item> event) {
        for (Item item : this.items) {
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public final void onModelRegistry(ModelRegistryEvent event) {
        for (Item item : this.items) {
            if (!(item instanceof IItemBuildCraft)) continue;
            ((IItemBuildCraft)item).registerVariants();
        }
    }

    @Nullable
    public <I extends Item> I addItem(I item) {
        return this.addItem(item, false);
    }

    @Nullable
    public <I extends Item> I addItem(I item, boolean force) {
        if (force || RegistryConfig.isEnabled(item)) {
            return this.addForcedItem(item);
        }
        return null;
    }

    public <I extends Item> I addForcedItem(I item) {
        IItemBuildCraft itemBC;
        String id;
        this.items.add(item);
        if (item instanceof IItemBuildCraft && !(id = (itemBC = (IItemBuildCraft)item).id()).isEmpty()) {
            String[] oldRegNames = TagManager.getMultiTag(id, TagManager.EnumTagTypeMulti.OLD_REGISTRY_NAME);
            MigrationManager.INSTANCE.addItemMigration(item, oldRegNames);
            if (TagManager.hasTag(id, TagManager.EnumTagType.OREDICT_NAME)) {
                oredictItems.put(TagManager.getTag(id, TagManager.EnumTagType.OREDICT_NAME), item);
            }
        }
        return item;
    }

    @Nullable
    public <B extends Block> B addBlock(B block) {
        return this.addBlock(block, false);
    }

    @Nullable
    public <B extends Block> B addBlock(B block, boolean force) {
        if (force || RegistryConfig.isEnabled(block)) {
            return this.addForcedBlock(block);
        }
        return null;
    }

    public <B extends Block> B addForcedBlock(B block) {
        String id;
        this.blocks.add(block);
        if (block instanceof BlockBCBase_Neptune && !(id = ((BlockBCBase_Neptune)block).id).isEmpty()) {
            String[] oldRegNames = TagManager.getMultiTag(id, TagManager.EnumTagTypeMulti.OLD_REGISTRY_NAME);
            MigrationManager.INSTANCE.addBlockMigration(block, oldRegNames);
            if (TagManager.hasTag(id, TagManager.EnumTagType.OREDICT_NAME)) {
                oredictBlocks.put(TagManager.getTag(id, TagManager.EnumTagType.OREDICT_NAME), block);
            }
        }
        return block;
    }

    @Nullable
    public <B extends BlockBCBase_Neptune> B addBlockAndItem(B block) {
        return (B)((Object)this.addBlockAndItem(block, false, ItemBlockBC_Neptune::new));
    }

    @Nullable
    public <B extends BlockBCBase_Neptune> B addBlockAndItem(B block, boolean force) {
        return (B)((Object)this.addBlockAndItem(block, force, ItemBlockBC_Neptune::new));
    }

    @Nullable
    public <B extends BlockBCBase_Neptune, I extends Item> B addBlockAndItem(B block, Function<B, I> itemBlockConstructor) {
        return this.addBlockAndItem(block, false, itemBlockConstructor);
    }

    public <B extends BlockBCBase_Neptune, I extends Item> B addBlockAndItem(B block, boolean force, Function<B, I> itemBlockConstructor) {
        B added = this.addBlock(block, force);
        if (added != null) {
            this.addForcedItem((Item)itemBlockConstructor.apply(added));
        } else {
            RegistryConfig.setDisabled("items", block.getRegistryName().func_110623_a());
        }
        return added;
    }

    public void registerTile(Class<? extends TileEntity> clazz, String id) {
        String regName = TagManager.getTag(id, TagManager.EnumTagType.REGISTRY_NAME);
        String[] alternatives = TagManager.getMultiTag(id, TagManager.EnumTagTypeMulti.OLD_REGISTRY_NAME);
        GameRegistry.registerTileEntity(clazz, (String)regName);
    }
}

