/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.inventory.IItemTransactor;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.StackUtil;
import gnu.trove.list.array.TIntArrayList;
import java.util.Arrays;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public abstract class AbstractInvItemTransactor
implements IItemTransactor {
    @Nonnull
    public static ItemStack asValid(@Nonnull ItemStack stack) {
        if (stack.func_190926_b()) {
            return StackUtil.EMPTY;
        }
        return stack;
    }

    @Nonnull
    protected abstract ItemStack insert(int var1, @Nonnull ItemStack var2, boolean var3);

    @Nonnull
    protected abstract ItemStack extract(int var1, IStackFilter var2, int var3, int var4, boolean var5);

    protected abstract int getSlots();

    protected abstract boolean isEmpty(int var1);

    @Override
    @Nonnull
    public ItemStack insert(@Nonnull ItemStack stack, boolean allAtOnce, boolean simulate) {
        if (allAtOnce) {
            return this.insertAllAtOnce(stack, simulate);
        }
        return this.insertAnyAmount(stack, simulate);
    }

    @Nonnull
    private ItemStack insertAnyAmount(@Nonnull ItemStack stack, boolean simulate) {
        int slotCount = this.getSlots();
        TIntArrayList emptySlots = new TIntArrayList(slotCount);
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (this.isEmpty(slot)) {
                emptySlots.add(slot);
                continue;
            }
            if (!(stack = this.insert(slot, stack, simulate)).func_190926_b()) continue;
            return StackUtil.EMPTY;
        }
        for (int slot : emptySlots.toArray()) {
            if (!(stack = this.insert(slot, stack, simulate)).func_190926_b()) continue;
            return StackUtil.EMPTY;
        }
        return stack;
    }

    @Nonnull
    private ItemStack insertAllAtOnce(@Nonnull ItemStack stack, boolean simulate) {
        ItemStack before = AbstractInvItemTransactor.asValid(stack);
        TIntArrayList insertedSlots = new TIntArrayList(this.getSlots());
        TIntArrayList emptySlots = new TIntArrayList(this.getSlots());
        for (int slot = 0; slot < this.getSlots(); ++slot) {
            if (this.isEmpty(slot)) {
                emptySlots.add(slot);
                continue;
            }
            stack = this.insert(slot, stack, true);
            insertedSlots.add(slot);
            if (stack.func_190926_b()) break;
        }
        for (int slot : emptySlots.toArray()) {
            stack = this.insert(slot, stack, true);
            insertedSlots.add(slot);
            if (stack.func_190926_b()) break;
        }
        if (!stack.func_190926_b()) {
            return stack;
        }
        if (simulate) {
            return StackUtil.EMPTY;
        }
        for (int slot : insertedSlots.toArray()) {
            before = this.insert(slot, before, false);
        }
        if (!before.func_190926_b()) {
            throw new IllegalStateException("Somehow inserting a lot of items at once failed when we thought it shouldn't! (" + this.getClass() + ")");
        }
        return StackUtil.EMPTY;
    }

    @Override
    public NonNullList<ItemStack> insert(NonNullList<ItemStack> stacks, boolean simulate) {
        return stacks;
    }

    @Override
    @Nonnull
    public ItemStack extract(IStackFilter filter, int min, int max, boolean simulate) {
        if (min < 1) {
            min = 1;
        }
        if (min > max) {
            return StackUtil.EMPTY;
        }
        if (max < 0) {
            return StackUtil.EMPTY;
        }
        if (filter == null) {
            filter = StackFilter.ALL;
        }
        int slots = this.getSlots();
        TIntArrayList valids = new TIntArrayList();
        int totalSize = 0;
        ItemStack toExtract = StackUtil.EMPTY;
        for (int slot = 0; slot < slots; ++slot) {
            ItemStack possible = this.extract(slot, filter, 1, max - totalSize, true);
            if (possible.func_190926_b()) continue;
            if (toExtract.func_190926_b()) {
                toExtract = possible.func_77946_l();
            }
            if (!StackUtil.canMerge(toExtract, possible)) continue;
            valids.add(slot);
            if ((totalSize += possible.func_190916_E()) >= max) break;
        }
        ItemStack total = StackUtil.EMPTY;
        if (min <= totalSize) {
            for (int slot : valids.toArray()) {
                ItemStack extracted = this.extract(slot, filter, 1, max - total.func_190916_E(), simulate);
                if (total.func_190926_b()) {
                    total = extracted.func_77946_l();
                    continue;
                }
                total.func_190917_f(extracted.func_190916_E());
            }
        }
        return total;
    }

    public String toString() {
        Object[] stacks = new ItemStack[this.getSlots()];
        for (int i = 0; i < stacks.length; ++i) {
            stacks[i] = this.extract(i, StackFilter.ALL, 1, Integer.MAX_VALUE, true);
        }
        return Arrays.toString(stacks);
    }
}

