/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftbutilities.net;

import com.feed_the_beast.ftblib.lib.data.Universe;
import com.feed_the_beast.ftblib.lib.io.DataIn;
import com.feed_the_beast.ftblib.lib.io.DataOut;
import com.feed_the_beast.ftblib.lib.net.MessageToServer;
import com.feed_the_beast.ftblib.lib.net.NetworkWrapper;
import com.feed_the_beast.ftbutilities.data.FTBUtilitiesUniverseData;
import com.feed_the_beast.ftbutilities.net.FTBUtilitiesNetHandler;
import com.feed_the_beast.ftbutilities.net.MessageSendBadge;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;

public class MessageRequestBadge
extends MessageToServer {
    private UUID playerId;

    public MessageRequestBadge() {
    }

    public MessageRequestBadge(UUID player) {
        this.playerId = player;
    }

    public NetworkWrapper getWrapper() {
        return FTBUtilitiesNetHandler.GENERAL;
    }

    public void writeData(DataOut data) {
        data.writeUUID(this.playerId);
    }

    public void readData(DataIn data) {
        this.playerId = data.readUUID();
    }

    public void onMessage(EntityPlayerMP player) {
        new ThreadBadge(this.playerId, player).start();
    }

    private static class ThreadBadge
    extends Thread {
        private final UUID playerId;
        private final EntityPlayerMP player;

        private ThreadBadge(UUID id, EntityPlayerMP p) {
            super("Badge_" + p.func_70005_c_());
            this.playerId = id;
            this.player = p;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            new MessageSendBadge(this.playerId, FTBUtilitiesUniverseData.getBadge(Universe.get(), this.playerId)).sendTo(this.player);
        }
    }
}

