/*
 * Decompiled with CFR 0.152.
 */
package rustic.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.Item;
import net.minecraft.util.EnumParticleTypes;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import rustic.common.items.ModItems;

public class MessageShameFX
implements IMessage {
    public static Random rand = new Random();
    int num = 0;
    double x = 0.0;
    double y = 0.0;
    double z = 0.0;
    double xVel = 0.0;
    double yVel = 0.0;
    double zVel = 0.0;
    double width = 0.0;
    double height = 0.0;

    public MessageShameFX() {
    }

    public MessageShameFX(int num, double x, double y, double z, double xVel, double yVel, double zVel, double width, double height) {
        this.num = num;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xVel = xVel;
        this.yVel = yVel;
        this.zVel = zVel;
        this.width = width;
        this.height = height;
    }

    public void fromBytes(ByteBuf buf) {
        this.num = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.xVel = buf.readDouble();
        this.yVel = buf.readDouble();
        this.zVel = buf.readDouble();
        this.width = buf.readDouble();
        this.height = buf.readDouble();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.num);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeDouble(this.xVel);
        buf.writeDouble(this.yVel);
        buf.writeDouble(this.zVel);
        buf.writeDouble(this.width);
        buf.writeDouble(this.height);
    }

    public static class MessageHolder
    implements IMessageHandler<MessageShameFX, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(MessageShameFX message, MessageContext ctx) {
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            if (world.field_72995_K) {
                for (int i = 0; i < message.num; ++i) {
                    double x = message.x + message.xVel;
                    double y = message.y + message.height * rand.nextDouble() + message.yVel;
                    double z = message.z + message.zVel;
                    switch (rand.nextInt(4)) {
                        case 3: {
                            x += message.width * (rand.nextDouble() - 0.5);
                            z -= message.width * 0.5;
                            break;
                        }
                        case 2: {
                            x += message.width * (rand.nextDouble() - 0.5);
                            z += message.width * 0.5;
                            break;
                        }
                        case 1: {
                            z += message.width * (rand.nextDouble() - 0.5);
                            x -= message.width * 0.5;
                            break;
                        }
                        default: {
                            z += message.width * (rand.nextDouble() - 0.5);
                            x += message.width * 0.5;
                        }
                    }
                    world.func_175682_a(EnumParticleTypes.ITEM_CRACK, true, x, y, z, message.xVel, message.yVel, message.zVel, new int[]{Item.func_150891_b((Item)ModItems.TOMATO)});
                }
            }
            return null;
        }
    }
}

