/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.inventory;

import com.enderio.core.common.inventory.InventorySlot;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.util.NullHelper;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.items.IItemHandler;

public class EnderInventory
implements IItemHandler {
    @Nonnull
    static final ItemStack CAKE = new ItemStack(Blocks.field_190982_dq, 0);
    @Nonnull
    private final Map<String, InventorySlot> idents = new HashMap<String, InventorySlot>();
    @Nonnull
    final EnumMap<Type, NNList<InventorySlot>> slots = new EnumMap(Type.class);
    @Nonnull
    private final View allSlots = new View(Type.ALL);
    @Nullable
    private TileEntity owner = null;
    @Nonnull
    public static final IItemHandler OFF = new IItemHandler(){

        public int getSlots() {
            return 0;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return CAKE;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return CAKE;
        }

        public int getSlotLimit(int slot) {
            return 0;
        }
    };

    public EnderInventory() {
        for (Type type : Type.values()) {
            this.slots.put(type, new NNList());
        }
    }

    public void add(@Nonnull Type type, @Nonnull Enum<?> ident, @Nonnull InventorySlot slot) {
        this.add(type, ident.name(), slot);
    }

    public void add(@Nonnull Type type, @Nonnull String ident, @Nonnull InventorySlot slot) {
        if (this.idents.containsKey(ident)) {
            throw new RuntimeException("Duplicate slot '" + ident + "'");
        }
        if (type == Type.ALL) {
            throw new RuntimeException("Invalid type '" + (Object)((Object)type) + "'");
        }
        this.idents.put(ident, slot);
        this.slots.get((Object)type).add(slot);
        this.slots.get((Object)Type.ALL).add(slot);
        if (type == Type.INPUT || type == Type.OUTPUT) {
            this.slots.get((Object)Type.INOUT).add(slot);
        }
        if (type == Type.INOUT) {
            this.slots.get((Object)Type.INPUT).add(slot);
            this.slots.get((Object)Type.OUTPUT).add(slot);
        }
        slot.setOwner(this.owner);
    }

    public InventorySlot getSlot(@Nonnull Enum<?> ident) {
        return this.getSlot(ident.name());
    }

    @Nonnull
    public InventorySlot getSlot(@Nonnull String ident) {
        if (!this.idents.containsKey(ident)) {
            throw new RuntimeException("Unknown slot '" + ident + "'");
        }
        return NullHelper.notnullJ(this.idents.get(ident), "Map.containsKey() lied to us");
    }

    public boolean hasSlot(@Nonnull Enum<?> ident) {
        return this.hasSlot(ident.name());
    }

    public boolean hasSlot(@Nonnull String ident) {
        return this.idents.containsKey(ident);
    }

    @Nonnull
    public View getView(@Nonnull Type type) {
        return new View(type);
    }

    @Nonnull
    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        this.writeToNBT(tag);
        return tag;
    }

    public void writeToNBT(@Nonnull NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            if (entry.getValue() == null) continue;
            NBTTagCompound subTag = new NBTTagCompound();
            entry.getValue().writeToNBT(subTag);
            if (subTag.func_82582_d()) continue;
            tag.func_74782_a(NullHelper.notnull(entry.getKey(), "Internal data corruption"), (NBTBase)subTag);
        }
    }

    public void readFromNBT(@Nonnull NBTTagCompound tag, @Nonnull String name) {
        this.readFromNBT(tag.func_74775_l(name));
    }

    public void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<String, InventorySlot> entry : this.idents.entrySet()) {
            String key = entry.getKey();
            InventorySlot slot = entry.getValue();
            if (slot == null || key == null) continue;
            if (tag.func_74764_b(key)) {
                slot.readFromNBT(tag.func_74775_l(key));
                continue;
            }
            slot.clear();
        }
    }

    public void setOwner(@Nullable TileEntity owner) {
        this.owner = owner;
        for (InventorySlot slot : this.idents.values()) {
            slot.setOwner(owner);
        }
    }

    public int getSlots() {
        return this.allSlots.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.allSlots.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (stack.func_190926_b()) {
            return CAKE;
        }
        return this.allSlots.insertItem(slot, stack, simulate);
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.allSlots.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.allSlots.getSlotLimit(slot);
    }

    public class View
    implements IItemHandler,
    Iterable<InventorySlot> {
        @Nonnull
        private final Type type;

        View(Type type) {
            this.type = type;
        }

        public InventorySlot getSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return EnderInventory.this.slots.get((Object)this.type).get(slot);
            }
            return null;
        }

        public int getSlots() {
            return EnderInventory.this.slots.get((Object)this.type).size();
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return EnderInventory.this.slots.get((Object)this.type).get(slot).getStackInSlot(0);
            }
            return CAKE;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (!stack.func_190926_b() && slot >= 0 && slot < this.getSlots()) {
                return EnderInventory.this.slots.get((Object)this.type).get(slot).insertItem(0, stack, simulate);
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (amount > 0 && slot >= 0 && slot < this.getSlots()) {
                return EnderInventory.this.slots.get((Object)this.type).get(slot).extractItem(0, amount, simulate);
            }
            return CAKE;
        }

        @Override
        public Iterator<InventorySlot> iterator() {
            return new Iterator<InventorySlot>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < View.this.getSlots();
                }

                @Override
                public InventorySlot next() {
                    return View.this.getSlot(this.i++);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("remove");
                }
            };
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot < this.getSlots()) {
                return EnderInventory.this.slots.get((Object)this.type).get(slot).getSlotLimit(0);
            }
            return 0;
        }

        @Nonnull
        public Type getType() {
            return this.type;
        }

        @Nonnull
        public EnderInventory getParent() {
            return EnderInventory.this;
        }
    }

    public static enum Type {
        ALL,
        INPUT,
        OUTPUT,
        INOUT,
        UPGRADE,
        INTERNAL;

    }
}

