/*
 * Decompiled with CFR 0.152.
 */
package thut.core.client.render.animation;

import com.google.common.collect.Maps;
import java.util.HashMap;
import javax.annotation.Nullable;
import org.w3c.dom.NamedNodeMap;
import thut.core.client.render.tabula.animation.AdvancedFlapAnimation;
import thut.core.client.render.tabula.animation.BasicFlapAnimation;
import thut.core.client.render.tabula.animation.BiWalkAnimation;
import thut.core.client.render.tabula.animation.QuadWalkAnimation;
import thut.core.client.render.tabula.animation.SnakeMovement;
import thut.core.client.render.tabula.components.Animation;

public class AnimationRegistry {
    public static HashMap<String, Class<? extends Animation>> animations = Maps.newHashMap();
    public static HashMap<String, String> animationPhases = Maps.newHashMap();

    public static Animation make(String name, NamedNodeMap map, @Nullable IPartRenamer renamer) {
        Animation ret = null;
        Class<? extends Animation> toMake = animations.get(name);
        if (toMake != null) {
            try {
                ret = toMake.newInstance();
                ret.init(map, renamer);
                if (animationPhases.containsKey(name)) {
                    ret.name = animationPhases.get(name);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    static {
        animations.put("quadWalk", QuadWalkAnimation.class);
        animations.put("biWalk", BiWalkAnimation.class);
        animations.put("flap", BasicFlapAnimation.class);
        animations.put("advFlap", AdvancedFlapAnimation.class);
        animations.put("snakeWalk", SnakeMovement.class);
        animations.put("snakeFly", SnakeMovement.class);
        animationPhases.put("snakeFly", "flying");
        animations.put("snakeIdle", SnakeMovement.class);
        animationPhases.put("snakeIdle", "idle");
        animations.put("snakeSwim", SnakeMovement.class);
        animationPhases.put("snakeSwim", "swimming");
    }

    public static interface IPartRenamer {
        public void convertToIdents(String[] var1);
    }
}

