/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.blocks;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.blocks.TileEntityIWBase;
import malte0811.industrialwires.util.MiscUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public abstract class TileEntityIWMultiblock
extends TileEntityIWBase
implements IEBlockInterfaces.IGeneralMultiblock,
IEBlockInterfaces.IDirectionalTile {
    protected static final String OFFSET = "offset";
    protected static final String FORMED = "formed";
    protected static final String MIRRORED = "mirrored";
    protected static final String FACING = "facing";
    protected Vec3i size;
    public Vec3i offset = new Vec3i(0, 1, 0);
    public boolean formed;
    public boolean mirrored;
    public long onlyLocalDissassembly;
    public EnumFacing facing = EnumFacing.NORTH;

    @Nonnull
    protected abstract BlockPos getOrigin();

    public abstract IBlockState getOriginalBlock();

    public ItemStack getOriginalItem() {
        IBlockState state = this.getOriginalBlock();
        return new ItemStack(state.func_177230_c(), 1, state.func_177230_c().func_176201_c(state));
    }

    public BiConsumer<World, BlockPos> getOriginalBlockPlacer() {
        return (w, p) -> w.func_175656_a(p, this.getOriginalBlock());
    }

    @Nullable
    public <T extends TileEntityIWMultiblock> T master(T here) {
        if (!this.isLogicDummy()) {
            return here;
        }
        TileEntity m = this.field_145850_b.func_175625_s(this.field_174879_c.func_177973_b(this.offset));
        if (m != null && m.getClass().equals(((Object)((Object)this)).getClass())) {
            return (T)((Object)((TileEntityIWMultiblock)m));
        }
        return null;
    }

    public boolean isLogicDummy() {
        return this.offset.func_177958_n() != 0 || this.offset.func_177956_o() != 0 || this.offset.func_177952_p() != 0;
    }

    @Nonnull
    public <T extends TileEntityIWMultiblock> T masterOr(T here, @Nonnull T def) {
        T master = this.master(here);
        return master != null ? master : def;
    }

    public void disassemble() {
        if (this.formed && !this.field_145850_b.field_72995_K) {
            BlockPos startPos = this.getOrigin();
            BlockPos masterPos = this.func_174877_v().func_177973_b(this.offset);
            long time = this.field_145850_b.func_82737_E();
            Vec3i size = this.getSize();
            for (int up = 0; up < size.func_177958_n(); ++up) {
                for (int forward = 0; forward < size.func_177956_o(); ++forward) {
                    for (int right = 0; right < size.func_177952_p(); ++right) {
                        BlockPos pos = MiscUtils.offset(startPos, this.facing, this.mirrored, right, forward, up);
                        TileEntity te = this.field_145850_b.func_175625_s(pos);
                        if (!(te instanceof TileEntityIWMultiblock)) continue;
                        TileEntityIWMultiblock part = (TileEntityIWMultiblock)te;
                        BlockPos diff = pos.func_177973_b((Vec3i)masterPos);
                        if (!part.offset.equals((Object)diff) || time == part.onlyLocalDissassembly) continue;
                        part.formed = false;
                        if (!pos.equals((Object)this.field_174879_c)) {
                            part.getOriginalBlockPlacer().accept(this.field_145850_b, pos);
                            continue;
                        }
                        if (part.getOriginalBlock() == null) continue;
                        ItemStack drop = this.getOriginalItem();
                        this.field_145850_b.func_72838_d((Entity)new EntityItem(this.field_145850_b, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, drop));
                    }
                }
            }
        }
    }

    @Override
    public void writeNBT(NBTTagCompound out, boolean updatePacket) {
        out.func_74768_a(FACING, this.facing.func_176736_b());
        out.func_74783_a(OFFSET, new int[]{this.offset.func_177958_n(), this.offset.func_177956_o(), this.offset.func_177952_p()});
        out.func_74757_a(MIRRORED, this.mirrored);
        out.func_74757_a(FORMED, this.formed);
    }

    @Override
    public void readNBT(NBTTagCompound in, boolean updatePacket) {
        this.formed = in.func_74767_n(FORMED);
        this.mirrored = in.func_74767_n(MIRRORED);
        int[] offset = in.func_74759_k(OFFSET);
        this.offset = new Vec3i(offset[0], offset[1], offset[2]);
        this.facing = EnumFacing.func_176731_b((int)in.func_74762_e(FACING));
    }

    public Vec3i getSize() {
        return this.size;
    }

    public int getRight() {
        return this.dot(this.offset, this.facing.func_176746_e().func_176730_m()) * (this.mirrored ? -1 : 1);
    }

    public int getForward() {
        return this.dot(this.offset, this.facing.func_176730_m());
    }

    protected int dot(Vec3i a, Vec3i b) {
        return a.func_177958_n() * b.func_177958_n() + a.func_177956_o() * b.func_177956_o() + a.func_177952_p() * b.func_177952_p();
    }

    @Nonnull
    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(@Nonnull EnumFacing facing) {
        this.facing = facing;
    }

    public int getFacingLimitation() {
        return 2;
    }

    public boolean mirrorFacingOnPlacement(@Nonnull EntityLivingBase placer) {
        return false;
    }

    public boolean canHammerRotate(@Nonnull EnumFacing side, float hitX, float hitY, float hitZ, @Nonnull EntityLivingBase entity) {
        return false;
    }

    public boolean canRotate(@Nonnull EnumFacing axis) {
        return false;
    }
}

