/*
 * Decompiled with CFR 0.152.
 */
package mcjty.deepresonance.radiation;

import com.google.common.collect.Maps;
import java.util.Map;
import mcjty.deepresonance.radiation.RadiationConfiguration;
import mcjty.deepresonance.radiation.RadiationShieldRegistry;
import mcjty.deepresonance.varia.QuadTree;
import mcjty.lib.varia.GlobalCoordinate;
import mcjty.lib.worlddata.AbstractWorldData;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DRRadiationManager
extends AbstractWorldData<DRRadiationManager> {
    private static final String RADIATION_MANAGER_NAME = "DRRadiationManager";
    private final Map<GlobalCoordinate, RadiationSource> sources = Maps.newHashMap();

    public DRRadiationManager(String name) {
        super(name);
    }

    public void clear() {
        this.sources.clear();
    }

    public static float calculateRadiationStrength(float strength, float purity) {
        float p = (float)Math.log10(purity / 100.0f) + 1.0f;
        if (p < 0.01f) {
            p = 0.01f;
        }
        float str = RadiationConfiguration.minRadiationStrength + strength * (1.0f - p) / 100.0f * (RadiationConfiguration.maxRadiationStrength - RadiationConfiguration.minRadiationStrength);
        return str;
    }

    public static float calculateRadiationRadius(float strength, float efficiency, float purity) {
        float radius = RadiationConfiguration.minRadiationRadius + (strength + efficiency) / 200.0f * (RadiationConfiguration.maxRadiationRadius - RadiationConfiguration.minRadiationRadius);
        radius += radius * (100.0f - purity) * 0.002f;
        return radius;
    }

    public void removeAllRadiation() {
        this.sources.clear();
    }

    public static DRRadiationManager getManager(World world) {
        return (DRRadiationManager)DRRadiationManager.getData((World)world, DRRadiationManager.class, (String)RADIATION_MANAGER_NAME);
    }

    public RadiationSource getOrCreateRadiationSource(GlobalCoordinate coordinate) {
        RadiationSource source = this.sources.get(coordinate);
        if (source == null) {
            source = new RadiationSource();
            this.sources.put(coordinate, source);
        }
        return source;
    }

    public RadiationSource getRadiationSource(GlobalCoordinate coordinate) {
        return this.sources.get(coordinate);
    }

    public Map<GlobalCoordinate, RadiationSource> getRadiationSources() {
        return this.sources;
    }

    public void deleteRadiationSource(GlobalCoordinate coordinate) {
        this.sources.remove(coordinate);
    }

    public void func_76184_a(NBTTagCompound tagCompound) {
        this.sources.clear();
        NBTTagList lst = tagCompound.func_150295_c("radiation", 10);
        for (int i = 0; i < lst.func_74745_c(); ++i) {
            NBTTagCompound tc = lst.func_150305_b(i);
            GlobalCoordinate coordinate = new GlobalCoordinate(new BlockPos(tc.func_74762_e("sourceX"), tc.func_74762_e("sourceY"), tc.func_74762_e("sourceZ")), tc.func_74762_e("dimension"));
            RadiationSource value = new RadiationSource();
            value.readFromNBT(tc);
            this.sources.put(coordinate, value);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound tagCompound) {
        NBTTagList lst = new NBTTagList();
        for (Map.Entry<GlobalCoordinate, RadiationSource> entry : this.sources.entrySet()) {
            NBTTagCompound tc = new NBTTagCompound();
            tc.func_74768_a("dimension", entry.getKey().getDimension());
            tc.func_74768_a("sourceX", entry.getKey().getCoordinate().func_177958_n());
            tc.func_74768_a("sourceY", entry.getKey().getCoordinate().func_177956_o());
            tc.func_74768_a("sourceZ", entry.getKey().getCoordinate().func_177952_p());
            entry.getValue().writeToNBT(tc);
            lst.func_74742_a((NBTBase)tc);
        }
        tagCompound.func_74782_a("radiation", (NBTBase)lst);
        return tagCompound;
    }

    public static class RadiationSource {
        private float radius;
        private float maxStrength;
        private float strength;
        private QuadTree radiationTree;

        public float getRadius() {
            return this.radius;
        }

        public void setRadius(float radius) {
            this.radius = radius;
        }

        public float getMaxStrength() {
            return this.maxStrength;
        }

        public void setMaxStrength(float maxStrength) {
            this.maxStrength = maxStrength;
        }

        public float getStrength() {
            return this.strength;
        }

        public void setStrength(float strength) {
            this.strength = strength;
        }

        public QuadTree getRadiationTree(World world, int centerX, int centerY, int centerZ) {
            if (this.radiationTree == null) {
                this.radiationTree = new QuadTree((int)((float)centerX - this.radius - 1.0f), (int)((float)centerY - this.radius - 1.0f), (int)((float)centerZ - this.radius - 1.0f), (int)((float)centerX + this.radius + 1.0f), (int)((float)centerY + this.radius + 1.0f), (int)((float)centerZ + this.radius + 1.0f));
                BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                int x = (int)((float)centerX - this.radius);
                while ((float)x < (float)centerX + this.radius) {
                    int y = (int)((float)centerY - this.radius);
                    while ((float)y < (float)centerY + this.radius) {
                        int z = (int)((float)centerZ - this.radius);
                        while ((float)z < (float)centerZ + this.radius) {
                            pos.func_181079_c(x, y, z);
                            IBlockState block = world.func_180495_p((BlockPos)pos);
                            float blocker = RadiationShieldRegistry.getBlocker(block);
                            if (blocker < 0.99f) {
                                this.radiationTree.addBlocker((BlockPos)pos, blocker);
                            }
                            ++z;
                        }
                        ++y;
                    }
                    ++x;
                }
            }
            return this.radiationTree;
        }

        public void update(float radius, float maxStrenght, int ticks) {
            this.maxStrength = maxStrenght;
            this.radius = radius;
            float toadd = maxStrenght * RadiationConfiguration.strengthGrowthFactor * (float)ticks;
            if (this.strength + toadd > maxStrenght && (toadd = maxStrenght - this.strength) < 0.0f) {
                toadd = 0.0f;
            }
            this.strength += toadd;
        }

        public void writeToNBT(NBTTagCompound tagCompound) {
            tagCompound.func_74776_a("radius", this.radius);
            tagCompound.func_74776_a("maxStrength", this.maxStrength);
            tagCompound.func_74776_a("strength", this.strength);
        }

        public void readFromNBT(NBTTagCompound tagCompound) {
            this.radius = tagCompound.func_74760_g("radius");
            this.maxStrength = tagCompound.func_74760_g("maxStrength");
            this.strength = tagCompound.func_74760_g("strength");
        }
    }
}

