/*
 * Decompiled with CFR 0.152.
 */
package mcjty.nice.blocks;

import javax.annotation.Nonnull;
import mcjty.nice.blocks.CylinderRenderer;
import mcjty.nice.blocks.CylinderTileEntity;
import mcjty.nice.blocks.GenericParticleBlock;
import mcjty.nice.client.BlockColor;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CylinderBlock
extends GenericParticleBlock
implements ITileEntityProvider {
    public static final AxisAlignedBB EMPTY = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");

    public CylinderBlock(String name, float scale) {
        super(name, scale);
    }

    @Override
    protected IBlockState getState() {
        return super.getState().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.UP);
    }

    @Override
    public void initClient() {
        super.initClient();
        CylinderRenderer.register();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return EMPTY;
    }

    @Nonnull
    public TileEntity func_149915_a(@Nonnull World worldIn, int meta) {
        return new CylinderTileEntity();
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (BlockColor color : BlockColor.values()) {
            if (color == BlockColor.TRANSP) continue;
            items.add((Object)CylinderBlock.makeColoredBlock(this, color, 1));
        }
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_82600_a((int)(meta & 7)));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, COLOR});
    }
}

