/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.tile.storage;

import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.nbt.NBTHelper;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;

public class StorageNetwork {
    private CoreArea master = null;
    private Map<BlockPos, AxisAlignedBB> cores = Maps.newHashMap();

    public boolean setMaster(@Nullable BlockPos pos) {
        if (pos == null) {
            this.master = null;
            return true;
        }
        if (this.cores.containsKey(pos)) {
            this.master = new CoreArea(pos, this.cores.get(pos));
            return true;
        }
        return false;
    }

    @Nullable
    public CoreArea getMaster() {
        return this.master;
    }

    public boolean addCore(BlockPos pos, AxisAlignedBB box) {
        return this.cores.put(pos, box) == null;
    }

    public boolean removeCore(BlockPos pos) {
        return this.cores.remove(pos) != null;
    }

    public List<CoreArea> getCores() {
        return MiscUtils.flatten(this.cores, (x$0, x$1) -> new CoreArea((BlockPos)x$0, (AxisAlignedBB)x$1));
    }

    public void writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (CoreArea coreData : this.getCores()) {
            NBTTagCompound coreTag = new NBTTagCompound();
            NBTHelper.writeBlockPosToNBT(coreData.getPos(), coreTag);
            NBTHelper.writeBoundingBox(coreData.getOffsetBox(), coreTag);
            list.func_74742_a((NBTBase)coreTag);
        }
        tag.func_74782_a("cores", (NBTBase)list);
        CoreArea master = this.getMaster();
        if (master != null) {
            NBTHelper.setAsSubTag(tag, "master", nbt -> NBTHelper.writeBlockPosToNBT(master.getPos(), nbt));
        }
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.cores.clear();
        NBTTagList list = tag.func_150295_c("cores", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound coreTag = list.func_150305_b(i);
            BlockPos pos = NBTHelper.readBlockPosFromNBT(coreTag);
            AxisAlignedBB box = NBTHelper.readBoundingBox(coreTag);
            this.addCore(pos, box);
        }
        this.setMaster(null);
        if (tag.func_150297_b("master", 10)) {
            BlockPos pos = NBTHelper.readBlockPosFromNBT(tag.func_74775_l("master"));
            this.setMaster(pos);
        }
    }

    public static class CoreArea {
        private final BlockPos pos;
        private final AxisAlignedBB offsetBox;

        private CoreArea(BlockPos pos, AxisAlignedBB offsetBox) {
            this.pos = pos;
            this.offsetBox = offsetBox;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public AxisAlignedBB getOffsetBox() {
            return this.offsetBox;
        }

        public AxisAlignedBB getRealBox() {
            return this.offsetBox.func_186670_a(this.getPos());
        }
    }
}

