/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.enchantment.amulet;

import baubles.api.BaubleType;
import com.google.common.collect.Maps;
import hellfirepvp.astralsorcery.common.enchantment.amulet.AmuletHolderCapability;
import hellfirepvp.astralsorcery.common.enchantment.amulet.registry.AmuletEnchantmentRegistry;
import hellfirepvp.astralsorcery.common.enchantment.dynamic.DynamicEnchantment;
import hellfirepvp.astralsorcery.common.event.DynamicEnchantmentEvent;
import hellfirepvp.astralsorcery.common.item.wearable.ItemEnchantmentAmulet;
import hellfirepvp.astralsorcery.common.util.BaublesHelper;
import hellfirepvp.astralsorcery.common.util.ItemComparator;
import hellfirepvp.astralsorcery.common.util.data.Tuple;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnchantmentUpgradeHelper {
    public static int getNewEnchantmentLevel(int current, int currentEnchantmentId, ItemStack item) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(item)) {
            return current;
        }
        return EnchantmentUpgradeHelper.getNewEnchantmentLevel(current, currentEnchantmentId, item, null);
    }

    public static int getNewEnchantmentLevel(int current, Enchantment enchantment, ItemStack item) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(item)) {
            return current;
        }
        return EnchantmentUpgradeHelper.getNewEnchantmentLevel(current, enchantment, item, null);
    }

    private static int getNewEnchantmentLevel(int current, int currentEnchantmentId, ItemStack item, @Nullable List<DynamicEnchantment> context) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(item)) {
            return current;
        }
        Enchantment ench = Enchantment.func_185262_c((int)currentEnchantmentId);
        if (ench != null) {
            return EnchantmentUpgradeHelper.getNewEnchantmentLevel(current, ench, item, context);
        }
        return current;
    }

    private static int getNewEnchantmentLevel(int current, Enchantment enchantment, ItemStack item, @Nullable List<DynamicEnchantment> context) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(item)) {
            return current;
        }
        if (item.func_190926_b() || !AmuletEnchantmentRegistry.canBeInfluenced(enchantment)) {
            return current;
        }
        List<DynamicEnchantment> modifiers = context != null ? context : EnchantmentUpgradeHelper.fireEnchantmentGatheringEvent(item);
        for (DynamicEnchantment mod : modifiers) {
            Enchantment target = mod.getEnchantment();
            switch (mod.getType()) {
                case ADD_TO_SPECIFIC: {
                    if (!enchantment.equals(target)) break;
                    current += mod.getLevelAddition();
                    break;
                }
                case ADD_TO_EXISTING_SPECIFIC: {
                    if (!enchantment.equals(target) || current <= 0) break;
                    current += mod.getLevelAddition();
                    break;
                }
                case ADD_TO_EXISTING_ALL: {
                    if (current <= 0) break;
                    current += mod.getLevelAddition();
                    break;
                }
            }
        }
        return current;
    }

    public static NBTTagList modifyEnchantmentTags(@Nonnull NBTTagList existingEnchantments, ItemStack stack) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(stack)) {
            return existingEnchantments;
        }
        List<DynamicEnchantment> context = EnchantmentUpgradeHelper.fireEnchantmentGatheringEvent(stack);
        if (context.isEmpty()) {
            return existingEnchantments;
        }
        NBTTagList returnNew = new NBTTagList();
        ArrayList<Enchantment> enchantments = new ArrayList<Enchantment>(existingEnchantments.func_74745_c());
        for (int i = 0; i < existingEnchantments.func_74745_c(); ++i) {
            NBTTagCompound cmp = existingEnchantments.func_150305_b(i);
            short enchId = cmp.func_74765_d("id");
            short lvl = cmp.func_74765_d("lvl");
            int newLvl = EnchantmentUpgradeHelper.getNewEnchantmentLevel((int)lvl, enchId, stack, context);
            NBTTagCompound newEnchTag = new NBTTagCompound();
            newEnchTag.func_74777_a("id", enchId);
            newEnchTag.func_74777_a("lvl", (short)newLvl);
            returnNew.func_74742_a((NBTBase)newEnchTag);
            Enchantment e = Enchantment.func_185262_c((int)enchId);
            if (e == null) continue;
            enchantments.add(e);
        }
        for (DynamicEnchantment mod : context) {
            EnumEnchantmentType type;
            Enchantment ench;
            if (mod.getType() != DynamicEnchantment.Type.ADD_TO_SPECIFIC || !AmuletEnchantmentRegistry.canBeInfluenced(ench = mod.getEnchantment()) || (type = ench.field_77351_y) != null && !type.func_77557_a(stack.func_77973_b()) || enchantments.contains(ench)) continue;
            NBTTagCompound newEnchTag = new NBTTagCompound();
            newEnchTag.func_74777_a("id", (short)Enchantment.func_185258_b((Enchantment)ench));
            newEnchTag.func_74777_a("lvl", (short)EnchantmentUpgradeHelper.getNewEnchantmentLevel(0, ench, stack, context));
            returnNew.func_74742_a((NBTBase)newEnchTag);
        }
        return returnNew;
    }

    public static Map<Enchantment, Integer> applyNewEnchantmentLevels(Map<Enchantment, Integer> enchantmentLevelMap, ItemStack stack) {
        if (EnchantmentUpgradeHelper.isItemBlacklisted(stack)) {
            return enchantmentLevelMap;
        }
        List<DynamicEnchantment> context = EnchantmentUpgradeHelper.fireEnchantmentGatheringEvent(stack);
        if (context.isEmpty()) {
            return enchantmentLevelMap;
        }
        LinkedHashMap copyRet = Maps.newLinkedHashMap();
        for (Map.Entry<Enchantment, Integer> enchant : enchantmentLevelMap.entrySet()) {
            copyRet.put(enchant.getKey(), EnchantmentUpgradeHelper.getNewEnchantmentLevel((int)enchant.getValue(), enchant.getKey(), stack, context));
        }
        for (DynamicEnchantment mod : context) {
            EnumEnchantmentType type;
            Enchantment ench;
            if (mod.getType() != DynamicEnchantment.Type.ADD_TO_SPECIFIC || !AmuletEnchantmentRegistry.canBeInfluenced(ench = mod.getEnchantment()) || (type = ench.field_77351_y) != null && !type.func_77557_a(stack.func_77973_b()) || enchantmentLevelMap.containsKey(ench)) continue;
            copyRet.put(ench, EnchantmentUpgradeHelper.getNewEnchantmentLevel(0, ench, stack, context));
        }
        return copyRet;
    }

    public static boolean isItemBlacklisted(ItemStack stack) {
        if (!stack.func_190926_b()) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                return true;
            }
            if (stack.func_77976_d() > 1) {
                return true;
            }
            if (stack.func_77973_b() instanceof ItemPotion || stack.func_77973_b() instanceof ItemEnchantedBook) {
                return true;
            }
            ResourceLocation rl = stack.func_77973_b().getRegistryName();
            if (rl == null) {
                return true;
            }
            return rl.func_110624_b().equalsIgnoreCase("draconicevolution");
        }
        return true;
    }

    private static List<DynamicEnchantment> fireEnchantmentGatheringEvent(ItemStack tool) {
        DynamicEnchantmentEvent.Add addEvent = new DynamicEnchantmentEvent.Add(tool, EnchantmentUpgradeHelper.getPlayerHavingTool(tool));
        MinecraftForge.EVENT_BUS.post((Event)addEvent);
        DynamicEnchantmentEvent.Modify modifyEvent = new DynamicEnchantmentEvent.Modify(tool, addEvent.getEnchantmentsToApply(), addEvent.getResolvedPlayer());
        MinecraftForge.EVENT_BUS.post((Event)modifyEvent);
        return modifyEvent.getEnchantmentsToApply();
    }

    public static void removeAmuletTagsAndCleanup(EntityPlayer player, boolean keepEquipped) {
        int i;
        InventoryPlayer inv = player.field_71071_by;
        for (i = 0; i < inv.field_70462_a.size(); ++i) {
            if (i == inv.field_70461_c && keepEquipped) continue;
            EnchantmentUpgradeHelper.removeAmuletOwner((ItemStack)inv.field_70462_a.get(i));
        }
        EnchantmentUpgradeHelper.removeAmuletOwner(inv.func_70445_o());
        if (!keepEquipped) {
            for (i = 0; i < inv.field_70460_b.size(); ++i) {
                EnchantmentUpgradeHelper.removeAmuletOwner((ItemStack)inv.field_70460_b.get(i));
            }
            for (i = 0; i < inv.field_184439_c.size(); ++i) {
                EnchantmentUpgradeHelper.removeAmuletOwner((ItemStack)inv.field_184439_c.get(i));
            }
        }
    }

    @Nullable
    private static UUID getWornPlayerUUID(ItemStack anyTool) {
        AmuletHolderCapability cap;
        if (!anyTool.func_190926_b() && anyTool.hasCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null) && (cap = (AmuletHolderCapability)anyTool.getCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null)) != null) {
            return cap.getHolderUUID();
        }
        return null;
    }

    public static void applyAmuletOwner(ItemStack tool, EntityPlayer wearer) {
        if (tool.func_190926_b() || !tool.hasCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null)) {
            return;
        }
        AmuletHolderCapability cap = (AmuletHolderCapability)tool.getCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null);
        if (cap == null) {
            return;
        }
        cap.setHolderUUID(wearer.func_110124_au());
    }

    private static void removeAmuletOwner(ItemStack stack) {
        if (stack.func_190926_b() || !stack.hasCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null)) {
            return;
        }
        AmuletHolderCapability cap = (AmuletHolderCapability)stack.getCapability(AmuletHolderCapability.CAPABILITY_AMULET_HOLDER, null);
        if (cap == null) {
            return;
        }
        cap.setHolderUUID(null);
    }

    @Nullable
    static EntityPlayer getPlayerHavingTool(ItemStack anyTool) {
        EntityPlayer player;
        UUID plUUID = EnchantmentUpgradeHelper.getWornPlayerUUID(anyTool);
        if (plUUID == null) {
            return null;
        }
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
            player = EnchantmentUpgradeHelper.resolvePlayerClient(plUUID);
        } else {
            MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
            if (server == null) {
                return null;
            }
            player = server.func_184103_al().func_177451_a(plUUID);
        }
        if (player == null) {
            return null;
        }
        boolean foundTool = false;
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = player.func_184582_a(slot);
            if (!ItemComparator.compare(stack, anyTool, ItemComparator.Clause.Sets.ITEMSTACK_STRICT)) continue;
            foundTool = true;
            break;
        }
        if (!foundTool) {
            return null;
        }
        return player;
    }

    @Nullable
    static Tuple<ItemStack, EntityPlayer> getWornAmulet(ItemStack anyTool) {
        EntityPlayer player = EnchantmentUpgradeHelper.getPlayerHavingTool(anyTool);
        if (player == null) {
            return null;
        }
        if (BaublesHelper.doesPlayerWearBauble(player, BaubleType.AMULET, stack -> !stack.func_190926_b() && stack.func_77973_b() instanceof ItemEnchantmentAmulet)) {
            ItemStack stack2 = BaublesHelper.getFirstWornBaublesForType(player, BaubleType.AMULET);
            return new Tuple<ItemStack, EntityPlayer>(stack2, player);
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private static EntityPlayer resolvePlayerClient(UUID plUUID) {
        WorldClient w = FMLClientHandler.instance().getWorldClient();
        if (w == null) {
            return null;
        }
        return w.func_152378_a(plUUID);
    }
}

