/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.teleportprobe;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import mcjty.lib.thirteen.Context;
import mcjty.rftools.blocks.teleporter.TeleportDestination;
import mcjty.rftools.blocks.teleporter.TeleportDestinationClientInfo;
import mcjty.rftools.blocks.teleporter.TeleportDestinations;
import mcjty.rftools.items.teleportprobe.PacketAllReceiversReady;
import mcjty.rftools.network.RFToolsMessages;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class PacketGetAllReceivers
implements IMessage {
    public void fromBytes(ByteBuf buf) {
    }

    public void toBytes(ByteBuf buf) {
    }

    public PacketGetAllReceivers() {
    }

    public PacketGetAllReceivers(ByteBuf buf) {
        this.fromBytes(buf);
    }

    public void handle(Supplier<Context> supplier) {
        Context ctx = supplier.get();
        ctx.enqueueWork(() -> {
            EntityPlayerMP player = ctx.getSender();
            TeleportDestinations destinations = TeleportDestinations.getDestinations(player.func_130014_f_());
            ArrayList<TeleportDestinationClientInfo> destinationList = new ArrayList<TeleportDestinationClientInfo>(destinations.getValidDestinations(player.func_130014_f_(), null));
            this.addDimensions(destinationList);
            this.addRfToolsDimensions(player.func_130014_f_(), destinationList);
            PacketAllReceiversReady msg = new PacketAllReceiversReady(destinationList);
            RFToolsMessages.INSTANCE.sendTo((IMessage)msg, player);
        });
        ctx.setPacketHandled(true);
    }

    private void addDimensions(List<TeleportDestinationClientInfo> destinationList) {
        WorldServer[] worlds;
        for (WorldServer world : worlds = DimensionManager.getWorlds()) {
            int id = world.field_73011_w.getDimension();
            TeleportDestination destination = new TeleportDestination(new BlockPos(0, 70, 0), id);
            destination.setName("Dimension: " + id);
            TeleportDestinationClientInfo teleportDestinationClientInfo = new TeleportDestinationClientInfo(destination);
            String dimName = world.field_73011_w.func_186058_p().func_186065_b();
            teleportDestinationClientInfo.setDimensionName(dimName);
            destinationList.add(teleportDestinationClientInfo);
        }
    }

    private void addRfToolsDimensions(World world, List<TeleportDestinationClientInfo> destinationList) {
    }
}

