/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler.darksteel;

import com.enderio.core.common.util.NullHelper;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.UpgradeRegistry;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class PacketUpgradeState
implements IMessage {
    private boolean isActive;
    private IDarkSteelUpgrade type;
    private int entityID;

    public PacketUpgradeState() {
    }

    public PacketUpgradeState(@Nonnull IDarkSteelUpgrade type, boolean isActive) {
        this(type, isActive, 0);
    }

    public PacketUpgradeState(@Nonnull IDarkSteelUpgrade type, boolean isActive, int entityID) {
        this.type = type;
        this.isActive = isActive;
        this.entityID = entityID;
    }

    public void toBytes(ByteBuf buf) {
        if (buf != null) {
            ByteBufUtils.writeRegistryEntry((ByteBuf)buf, (IForgeRegistryEntry)((IForgeRegistryEntry)NullHelper.notnullF((Object)this.type, (String)"packet uninitialized")));
            buf.writeBoolean(this.isActive);
            buf.writeInt(this.entityID);
        }
    }

    public void fromBytes(ByteBuf buf) {
        if (buf != null) {
            this.type = UpgradeRegistry.read(buf);
            this.isActive = buf.readBoolean();
            this.entityID = buf.readInt();
        }
    }

    public static class ServerHandler
    implements IMessageHandler<PacketUpgradeState, IMessage> {
        public IMessage onMessage(PacketUpgradeState message, MessageContext ctx) {
            EntityPlayerMP player = ctx.getServerHandler().field_147369_b;
            IDarkSteelUpgrade type = message.type;
            if (type != null) {
                DarkSteelController.setActive((EntityPlayer)player, type, message.isActive);
            }
            return null;
        }
    }

    public static class ClientHandler
    implements IMessageHandler<PacketUpgradeState, IMessage> {
        @SideOnly(value=Side.CLIENT)
        public IMessage onMessage(PacketUpgradeState message, MessageContext ctx) {
            Entity player = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
            IDarkSteelUpgrade type = message.type;
            if (player instanceof EntityPlayer && type != null) {
                DarkSteelController.syncActive((EntityPlayer)player, type, message.isActive);
            }
            return null;
        }
    }
}

