/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.handler;

import crazypants.enderio.api.tool.IConduitControl;
import crazypants.enderio.api.upgrades.IDarkSteelUpgrade;
import crazypants.enderio.base.EnderIO;
import crazypants.enderio.base.conduit.ConduitDisplayMode;
import crazypants.enderio.base.handler.darksteel.DarkSteelController;
import crazypants.enderio.base.handler.darksteel.gui.PacketOpenDSU;
import crazypants.enderio.base.init.ModObject;
import crazypants.enderio.base.integration.baubles.BaublesUtil;
import crazypants.enderio.base.integration.thaumcraft.GogglesOfRevealingUpgrade;
import crazypants.enderio.base.item.conduitprobe.PacketConduitProbeMode;
import crazypants.enderio.base.item.darksteel.upgrade.elytra.ElytraUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.glider.GliderUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.jump.JumpUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.nightvision.NightVisionUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetector;
import crazypants.enderio.base.item.darksteel.upgrade.sound.SoundDetectorUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.speed.SpeedUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.stepassist.StepAssistUpgrade;
import crazypants.enderio.base.item.darksteel.upgrade.storage.PacketOpenInventory;
import crazypants.enderio.base.item.magnet.ItemMagnet;
import crazypants.enderio.base.item.magnet.MagnetController;
import crazypants.enderio.base.item.magnet.PacketMagnetState;
import crazypants.enderio.base.item.yetawrench.PacketYetaWrenchDisplayMode;
import crazypants.enderio.base.network.PacketHandler;
import crazypants.enderio.base.sound.IModSound;
import crazypants.enderio.base.sound.SoundHelper;
import crazypants.enderio.base.sound.SoundRegistry;
import crazypants.enderio.util.Prep;
import crazypants.enderio.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="enderio", value={Side.CLIENT})
public class KeyTracker {
    @Nonnull
    private static final List<Pair<KeyBinding, Action>> keyActions = new ArrayList<Pair<KeyBinding, Action>>();
    @Nonnull
    private static final KeyBinding fovPlusKeyFast;
    @Nonnull
    private static final KeyBinding fovMinusKeyFast;
    @Nonnull
    private static final KeyBinding fovPlusKey;
    @Nonnull
    private static final KeyBinding fovMinusKey;
    @Nonnull
    private static final KeyBinding yetaWrenchMode;
    @Nonnull
    public static final KeyBinding inventory;
    @Nonnull
    public static final KeyBinding dsu;
    private static double fovLevelLast;
    private static double fovLevelNext;
    private static long lastWorldTime;

    @Nonnull
    public static KeyBinding create(@Nonnull String description, int keyCode, @Nonnull String category, @Nonnull Action action) {
        KeyBinding keyBinding = KeyTracker.create(description, keyCode, category);
        keyActions.add((Pair<KeyBinding, Action>)Pair.of((Object)keyBinding, (Object)action));
        return keyBinding;
    }

    @Nonnull
    public static KeyBinding create(@Nonnull String description, int keyCode, @Nonnull String category) {
        KeyBinding keyBinding = new KeyBinding(description.trim(), keyCode, category.trim());
        ClientRegistry.registerKeyBinding((KeyBinding)keyBinding);
        return keyBinding;
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        for (Pair<KeyBinding, Action> keyAction : keyActions) {
            if (!((KeyBinding)keyAction.getKey()).func_151468_f()) continue;
            ((Action)keyAction.getValue()).execute();
        }
        if (!KeyTracker.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
            SoundDetector.setEnabled(false);
        }
    }

    public static void sendEnabledChatMessage(@Nonnull String messageBase, boolean isActive) {
        StringUtil.sendEnabledChatMessage((EntityPlayer)Minecraft.func_71410_x().field_71439_g, EnderIO.lang.addPrefix(messageBase), isActive);
    }

    public static void toggleDarkSteelController(@Nonnull IDarkSteelUpgrade type, @Nonnull String messageBase) {
        boolean isActive = !DarkSteelController.isActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type);
        KeyTracker.sendEnabledChatMessage(messageBase, isActive);
        DarkSteelController.setActive((EntityPlayer)Minecraft.func_71410_x().field_71439_g, type, isActive);
    }

    public static boolean isSoundDetectorUpgradeEquipped(EntityPlayerSP player) {
        ItemStack helmet = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return SoundDetectorUpgrade.INSTANCE.hasUpgrade(helmet);
    }

    @SubscribeEvent
    public static void onFov(EntityViewRenderEvent.FOVModifier event) {
        long worldTime = EnderIO.proxy.getTickCount();
        while (worldTime > lastWorldTime) {
            lastWorldTime = worldTime - lastWorldTime > 10L ? worldTime : ++lastWorldTime;
            fovLevelLast = fovLevelNext;
            if (fovPlusKeyFast.func_151470_d()) {
                fovLevelNext *= 1.05;
            } else if (fovMinusKeyFast.func_151470_d()) {
                fovLevelNext /= 1.05;
            } else if (fovPlusKey.func_151470_d()) {
                fovLevelNext *= 1.01;
            } else if (fovMinusKey.func_151470_d()) {
                fovLevelNext /= 1.01;
            }
            fovLevelNext = MathHelper.func_151237_a((double)fovLevelNext, (double)0.05, (double)1.3);
        }
        double val = fovLevelNext * event.getRenderPartialTicks() + fovLevelLast * (1.0 - event.getRenderPartialTicks());
        event.setFOV((float)((double)event.getFOV() * val));
    }

    public static KeyBinding getYetaWrenchMode() {
        return yetaWrenchMode;
    }

    static {
        inventory = KeyTracker.create("enderio.keybind.inventory", 23, "key.category.darksteelarmor    ", new InventoryAction());
        dsu = KeyTracker.create("enderio.keybind.dsu         ", 0, "key.category.darksteelarmor    ", new DSUAction());
        KeyTracker.create("enderio.keybind.glidertoggle      ", 34, "   key.category.darksteelarmor    ", new GlideAction());
        KeyTracker.create("enderio.keybind.soundlocator      ", 0, "key.category.darksteelarmor    ", new SoundDetectorAction());
        KeyTracker.create("enderio.keybind.nightvision       ", 25, "   key.category.darksteelarmor    ", new NightVisionAction());
        KeyTracker.create("enderio.keybind.gogglesofrevealing", 0, "key.category.darksteelarmor    ", new GogglesAction());
        KeyTracker.create("enderio.keybind.stepassist        ", 0, "key.category.darksteelarmor    ", new StepAssistAction());
        KeyTracker.create("enderio.keybind.speed             ", 0, "key.category.darksteelarmor    ", new SpeedAction());
        KeyTracker.create("enderio.keybind.jump              ", 0, "key.category.darksteelarmor    ", new JumpAction());
        KeyTracker.create("enderio.keybind.top               ", 0, "key.category.darksteelarmor    ", new TopAction());
        yetaWrenchMode = KeyTracker.create("enderio.keybind.yetawrenchmode", 21, "   key.category.tools             ", new YetaWrenchAction());
        KeyTracker.create("enderio.keybind.magnet            ", 0, "key.category.tools             ", new MagnetAction());
        KeyTracker.create("enderio.keybind.fovreset          ", 0, "key.categories.misc            ", new FovAction());
        fovPlusKey = KeyTracker.create("     enderio.keybind.fovplus     ", 0, "key.categories.misc");
        fovMinusKey = KeyTracker.create("    enderio.keybind.fovminus    ", 0, "key.categories.misc");
        fovPlusKeyFast = KeyTracker.create(" enderio.keybind.fovplusfast ", 0, "key.categories.misc");
        fovMinusKeyFast = KeyTracker.create("enderio.keybind.fovminusfast", 0, "key.categories.misc");
        fovLevelLast = 1.0;
        fovLevelNext = 1.0;
        lastWorldTime = 0L;
    }

    private static class FovAction
    implements Action {
        private FovAction() {
        }

        @Override
        public void execute() {
            fovLevelLast = (fovLevelNext = 1.0);
        }
    }

    private static class TopAction
    implements Action {
        private TopAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.isTopUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive = !DarkSteelController.isTopActive((EntityPlayer)player);
                DarkSteelController.setTopActive((EntityPlayer)player, isActive);
            }
        }
    }

    private static class NightVisionAction
    implements Action {
        private NightVisionAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (DarkSteelController.isNightVisionUpgradeEquipped((EntityPlayer)player)) {
                boolean isActive;
                boolean bl = isActive = !DarkSteelController.isActive((EntityPlayer)player, NightVisionUpgrade.INSTANCE);
                if (isActive) {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_ON, 0.1f, player.field_70170_p.field_73012_v.nextFloat() * 0.4f - 0.2f + 1.0f);
                } else {
                    SoundHelper.playSound(player.field_70170_p, (Entity)player, (IModSound)SoundRegistry.NIGHTVISION_OFF, 0.1f, 1.0f);
                }
                DarkSteelController.setActive((EntityPlayer)player, NightVisionUpgrade.INSTANCE, isActive);
            }
        }
    }

    private static class GlideAction
    implements Action {
        private GlideAction() {
        }

        @Override
        public void execute() {
            if (DarkSteelController.isGliderUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(GliderUpgrade.INSTANCE, "darksteel.upgrade.glider");
            } else if (DarkSteelController.isElytraUpgradeEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(ElytraUpgrade.INSTANCE, "darksteel.upgrade.elytra");
            }
        }
    }

    private static class SoundDetectorAction
    implements Action {
        private SoundDetectorAction() {
        }

        @Override
        public void execute() {
            if (KeyTracker.isSoundDetectorUpgradeEquipped(Minecraft.func_71410_x().field_71439_g)) {
                boolean isActive = !SoundDetector.isEnabled();
                KeyTracker.sendEnabledChatMessage("darksteel.upgrade.sound", isActive);
                SoundDetector.setEnabled(isActive);
            }
        }
    }

    private static class YetaWrenchAction
    implements Action {
        private YetaWrenchAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            ItemStack equipped = player.func_184614_ca();
            if (Prep.isInvalid(equipped)) {
                return;
            }
            if (equipped.func_77973_b() instanceof IConduitControl) {
                ConduitDisplayMode curMode = ConduitDisplayMode.getDisplayMode(equipped);
                ConduitDisplayMode newMode = player.func_70093_af() ? curMode.previous() : curMode.next();
                ConduitDisplayMode.setDisplayMode(equipped, newMode);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketYetaWrenchDisplayMode(player.field_71071_by.field_70461_c, newMode));
            } else if (equipped.func_77973_b() == ModObject.itemConduitProbe.getItem()) {
                int newMeta = equipped.func_77952_i() == 0 ? 1 : 0;
                equipped.func_77964_b(newMeta);
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketConduitProbeMode());
                player.func_184609_a(EnumHand.MAIN_HAND);
            }
        }
    }

    private static class GogglesAction
    implements Action {
        private GogglesAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (GogglesOfRevealingUpgrade.isUpgradeEquipped((EntityPlayer)player)) {
                KeyTracker.toggleDarkSteelController(GogglesOfRevealingUpgrade.INSTANCE, "darksteel.upgrades.goggles");
            }
        }
    }

    private static class StepAssistAction
    implements Action {
        private StepAssistAction() {
        }

        @Override
        public void execute() {
            if (JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(StepAssistUpgrade.INSTANCE, "darksteel.upgrade.stepAssist");
            }
        }
    }

    private static class SpeedAction
    implements Action {
        private SpeedAction() {
        }

        @Override
        public void execute() {
            if (SpeedUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(SpeedUpgrade.SPEED_ONE, "darksteel.upgrade.speed");
            }
        }
    }

    private static class JumpAction
    implements Action {
        private JumpAction() {
        }

        @Override
        public void execute() {
            if (JumpUpgrade.isEquipped((EntityPlayer)Minecraft.func_71410_x().field_71439_g)) {
                KeyTracker.toggleDarkSteelController(JumpUpgrade.JUMP_ONE, "darksteel.upgrade.jump");
            }
        }
    }

    private static class DSUAction
    implements Action {
        private DSUAction() {
        }

        @Override
        public void execute() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenDSU());
        }
    }

    private static class InventoryAction
    implements Action {
        private InventoryAction() {
        }

        @Override
        public void execute() {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketOpenInventory());
        }
    }

    private static class MagnetAction
    implements Action {
        private MagnetAction() {
        }

        @Override
        public void execute() {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            MagnetController.ActiveMagnet magnet = MagnetController.getMagnet((EntityPlayer)player, false);
            if (magnet != null) {
                boolean isActive = !ItemMagnet.isActive(magnet.getItem());
                PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.INVENTORY, magnet.getSlot(), isActive));
                return;
            }
            IInventory baubles = BaublesUtil.instance().getBaubles((EntityPlayer)player);
            if (baubles != null) {
                for (int i = 0; i < baubles.func_70302_i_(); ++i) {
                    ItemStack stack = baubles.func_70301_a(i);
                    if (!ItemMagnet.isMagnet(stack)) continue;
                    boolean isActive = !ItemMagnet.isActive(stack);
                    PacketHandler.INSTANCE.sendToServer((IMessage)new PacketMagnetState(PacketMagnetState.SlotType.BAUBLES, i, isActive));
                    return;
                }
            }
        }
    }

    public static interface Action {
        public void execute();
    }
}

