/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.base.conduit.geom;

import com.enderio.core.api.client.render.VertexTransform;
import com.enderio.core.client.render.BoundingBox;
import com.enderio.core.client.render.RenderUtil;
import com.enderio.core.client.render.VertexRotation;
import com.enderio.core.client.render.VertexTransformComposite;
import com.enderio.core.client.render.VertexTranslation;
import com.enderio.core.common.util.ForgeDirectionOffsets;
import com.enderio.core.common.util.NNList;
import com.enderio.core.common.vecmath.VecmathUtil;
import com.enderio.core.common.vecmath.Vector3d;
import com.enderio.core.common.vecmath.Vector3f;
import com.enderio.core.common.vecmath.Vector4f;
import com.enderio.core.common.vecmath.Vertex;
import crazypants.enderio.base.conduit.IConduit;
import crazypants.enderio.base.conduit.geom.GeometryKey;
import crazypants.enderio.base.conduit.geom.Offset;
import crazypants.enderio.base.config.config.PersonalConfig;
import crazypants.enderio.base.events.EnderIOLifecycleEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="enderio")
public final class ConduitGeometryUtil {
    @Nonnull
    private static ConduitGeometryUtil instance = new ConduitGeometryUtil(0.1875f);
    private final float CONNECTOR_DEPTH = 0.05f;
    private final float WIDTH;
    private final float HEIGHT;
    private final float HWIDTH;
    private final float HHEIGHT;
    @Nonnull
    private final BoundingBox CORE_BOUNDS;
    @Nonnull
    private final Map<EnumFacing, BoundingBox[]> EXTERNAL_CONNECTOR_BOUNDS = new EnumMap<EnumFacing, BoundingBox[]>(EnumFacing.class);
    @Nonnull
    private final Map<GeometryKey, BoundingBox> boundsCache = new HashMap<GeometryKey, BoundingBox>();
    @Nonnull
    private final EnumMap<EnumFacing, List<Vertex>> IO_RING_VERTS = new EnumMap(EnumFacing.class);

    @Nonnull
    public static ConduitGeometryUtil getInstance() {
        return instance;
    }

    @SubscribeEvent
    public static void preInit(EnderIOLifecycleEvent.Config.Post event) {
        instance = new ConduitGeometryUtil(0.0625f * (float)((Integer)PersonalConfig.conduitPixels.get()).intValue());
    }

    @Nonnull
    private BoundingBox[] createExternalConnector(@Nonnull EnumFacing dir, float connectorDepth, float connectorWidth) {
        BoundingBox[] res = new BoundingBox[2];
        float cMin = 0.5f - connectorWidth / 2.0f;
        float cMax = 0.5f + connectorWidth / 2.0f;
        float dMin = 1.0f - connectorDepth / 2.0f;
        float dMax = 1.0f;
        res[0] = this.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        cMin = 0.5f - connectorWidth / 3.0f;
        cMax = 0.5f + connectorWidth / 3.0f;
        dMin = 1.0f - connectorDepth;
        dMax = 1.0f - connectorDepth / 2.0f;
        res[1] = this.createConnectorComponent(dir, cMin, cMax, dMin, dMax);
        return res;
    }

    @Nonnull
    private BoundingBox createConnectorComponent(@Nonnull EnumFacing dir, float cornerMin, float cornerMax, float depthMin, float depthMax) {
        float minX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMin + (float)dir.func_82601_c() * depthMin;
        float minY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMin + (float)dir.func_96559_d() * depthMin;
        float minZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMin + (float)dir.func_82599_e() * depthMin;
        float maxX = (float)(1 - Math.abs(dir.func_82601_c())) * cornerMax + (float)dir.func_82601_c() * depthMax;
        float maxY = (float)(1 - Math.abs(dir.func_96559_d())) * cornerMax + (float)dir.func_96559_d() * depthMax;
        float maxZ = (float)(1 - Math.abs(dir.func_82599_e())) * cornerMax + (float)dir.func_82599_e() * depthMax;
        minX = ConduitGeometryUtil.fix(minX);
        minY = ConduitGeometryUtil.fix(minY);
        minZ = ConduitGeometryUtil.fix(minZ);
        maxX = ConduitGeometryUtil.fix(maxX);
        maxY = ConduitGeometryUtil.fix(maxY);
        maxZ = ConduitGeometryUtil.fix(maxZ);
        BoundingBox bb = new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
        bb = bb.fixMinMax();
        return bb;
    }

    private static float fix(float val) {
        return val < 0.0f ? 1.0f + val : val;
    }

    private ConduitGeometryUtil(float size) {
        this.WIDTH = size;
        this.HEIGHT = size;
        this.HWIDTH = this.WIDTH / 2.0f;
        this.HHEIGHT = this.HEIGHT / 2.0f;
        Vector3d core_min = new Vector3d((double)(0.5f - this.HWIDTH), 0.5 - (double)this.HHEIGHT, 0.5 - (double)this.HWIDTH);
        Vector3d core_max = new Vector3d(core_min.x + (double)this.WIDTH, core_min.y + (double)this.HEIGHT, core_min.z + (double)this.WIDTH);
        this.CORE_BOUNDS = new BoundingBox(core_min, core_max);
        float connectorWidth = Math.min(0.125f + size * 3.0f, 1.0f);
        NNList.NNIterator itr = NNList.FACING.fastIterator();
        while (itr.hasNext()) {
            EnumFacing dir = (EnumFacing)itr.next();
            this.EXTERNAL_CONNECTOR_BOUNDS.put(dir, this.createExternalConnector(dir, 0.05f, connectorWidth));
        }
        this.createIORingVerts();
    }

    @Nonnull
    public BoundingBox getExternalConnectorBoundingBox(@Nonnull EnumFacing dir) {
        return this.getExternalConnectorBoundingBoxes(dir)[0];
    }

    @Nonnull
    public BoundingBox[] getExternalConnectorBoundingBoxes(@Nonnull EnumFacing dir) {
        return this.EXTERNAL_CONNECTOR_BOUNDS.get(dir);
    }

    @Nonnull
    public BoundingBox getBoundingBox(@Nonnull Class<? extends IConduit> type, EnumFacing dir, @Nonnull Offset offset) {
        GeometryKey key = new GeometryKey(dir, offset, type);
        BoundingBox result = this.boundsCache.get(key);
        if (result == null) {
            result = this.createConduitBounds(type, key);
            this.boundsCache.put(key, result);
        }
        return result;
    }

    @Nonnull
    public Vector3d getTranslation(EnumFacing dir, @Nonnull Offset offset) {
        Vector3d result = new Vector3d((double)offset.xOffset, (double)offset.yOffset, (double)offset.zOffset);
        result.scale((double)this.WIDTH);
        return result;
    }

    @Nonnull
    public BoundingBox createBoundsForConnectionController(@Nonnull EnumFacing dir, @Nonnull Offset offset) {
        Vector3d nonUniformScale = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        nonUniformScale.scale(0.5);
        nonUniformScale.x = 0.8 * (1.0 - Math.abs(nonUniformScale.x));
        nonUniformScale.y = 0.8 * (1.0 - Math.abs(nonUniformScale.y));
        nonUniformScale.z = 0.8 * (1.0 - Math.abs(nonUniformScale.z));
        BoundingBox bb = this.CORE_BOUNDS;
        bb = bb.scale(nonUniformScale.x, nonUniformScale.y, nonUniformScale.z);
        double offsetFromEnd = Math.min(bb.sizeX(), bb.sizeY());
        offsetFromEnd = Math.min(offsetFromEnd, bb.sizeZ());
        offsetFromEnd = Math.max(offsetFromEnd, 0.075);
        double transMag = 0.5 - offsetFromEnd * 1.2;
        Vector3d trans = ForgeDirectionOffsets.forDirCopy((EnumFacing)dir);
        trans.scale(transMag);
        bb = bb.translate(trans);
        bb = bb.translate(this.getTranslation(dir, offset));
        return bb;
    }

    @Nonnull
    private BoundingBox createConduitBounds(@Nonnull Class<? extends IConduit> type, @Nonnull GeometryKey key) {
        return this.createConduitBounds(type, key.dir, key.offset);
    }

    @Nonnull
    private BoundingBox createConduitBounds(Class<? extends IConduit> type, EnumFacing dir, @Nonnull Offset offset) {
        BoundingBox bb = this.CORE_BOUNDS;
        Vector3d min = bb.getMin();
        Vector3d max = bb.getMax();
        if (dir != null) {
            switch (dir) {
                case WEST: {
                    min.x = 0.0;
                    max.x = bb.field_72340_a;
                    break;
                }
                case EAST: {
                    min.x = bb.field_72336_d;
                    max.x = 1.0;
                    break;
                }
                case DOWN: {
                    min.y = 0.0;
                    max.y = bb.field_72338_b;
                    break;
                }
                case UP: {
                    min.y = bb.field_72337_e;
                    max.y = 1.0;
                    break;
                }
                case NORTH: {
                    min.z = 0.0;
                    max.z = bb.field_72339_c;
                    break;
                }
                case SOUTH: {
                    min.z = bb.field_72334_f;
                    max.z = 1.0;
                    break;
                }
            }
        }
        Vector3d trans = this.getTranslation(dir, offset);
        min.add(trans);
        max.add(trans);
        bb = new BoundingBox(VecmathUtil.clamp((Vector3d)min, (double)0.0, (double)1.0), VecmathUtil.clamp((Vector3d)max, (double)0.0, (double)1.0));
        return bb;
    }

    public float getHeight() {
        return this.HEIGHT;
    }

    private void createIORingVerts() {
        float scale = 0.9f;
        BoundingBox refBB = this.CORE_BOUNDS;
        refBB = refBB.scale(scale, scale, scale);
        refBB = refBB.scale(scale, 1.0f, 1.0f);
        double offset = this.HWIDTH * scale * scale + 0.05f;
        VertexRotation vrot = new VertexRotation(1.5707963267948966, new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.5, 0.5));
        VertexTranslation vtrans = new VertexTranslation(0.0f, 0.0f, 0.0f);
        VertexTransformComposite xform = new VertexTransformComposite(new VertexTransform[]{vrot, vtrans});
        EnumFacing dir = EnumFacing.SOUTH;
        Vector3d trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.NORTH;
        vrot.setAngle(4.71238898038469);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.EAST;
        vrot.setAngle(Math.PI);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.WEST;
        vrot.setAngle(0.0);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
        vrot.setAxis(new Vector3d(0.0, 0.0, 1.0));
        dir = EnumFacing.UP;
        vrot.setAngle(-1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
        dir = EnumFacing.DOWN;
        vrot.setAngle(1.5707963267948966);
        trans = ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)0.5);
        trans.sub(ForgeDirectionOffsets.offsetScaled((EnumFacing)dir, (double)offset));
        vtrans.set(trans);
        this.IO_RING_VERTS.put(dir, this.createVerticesForDir(refBB, (VertexTransform)xform));
    }

    @Nullable
    private List<Vertex> createVerticesForDir(BoundingBox refBB, VertexTransform xform) {
        ArrayList<Vertex> result = new ArrayList<Vertex>(24);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (face == null) continue;
            result.addAll(refBB.getCornersWithUvForFace(face));
        }
        for (Vertex v : result) {
            xform.apply(v.xyz);
            Vector3f normal = v.normal;
            if (normal == null) continue;
            xform.applyToNormal(normal);
        }
        return result;
    }

    @SideOnly(value=Side.CLIENT)
    public void addModeConnectorQuads(EnumFacing dir, @Nonnull Offset offset, @Nonnull TextureAtlasSprite tex, Vector4f color, @Nonnull List<BakedQuad> quads) {
        List<Vertex> verts = this.IO_RING_VERTS.get(dir);
        if (verts == null) {
            return;
        }
        Vector3d trans = this.getTranslation(dir, offset);
        ArrayList<Vertex> xFormed = new ArrayList<Vertex>(verts.size());
        for (Vertex v : verts) {
            Vertex xf = new Vertex(v);
            xf.xyz.add(trans);
            xFormed.add(xf);
        }
        RenderUtil.addBakedQuads(quads, xFormed, (TextureAtlasSprite)tex, (Vector4f)color);
    }
}

